/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DemultiplexorInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LazyReadInputStream
extends DemultiplexorInputStream {
    private byte[] m_buf = null;
    private byte[] m_oldBuf = new byte[0];
    private byte[] m_eodStr = null;
    private InputStream m_underlyingStream;
    private boolean m_endOfUnderlyingStreamReached;

    public LazyReadInputStream(InputStream a_in) {
        super(a_in);
        this.m_underlyingStream = a_in;
        this.m_endOfUnderlyingStreamReached = false;
    }

    public synchronized int read() throws IOException {
        int byteRead = -1;
        if (this.m_eodStr != null) {
            if (this.m_buf == null) {
                this.m_buf = new byte[this.m_eodStr.length];
                int pos = 0;
                while (pos < this.m_buf.length) {
                    int nextByte = this.readAhead();
                    if (nextByte != -1) {
                        this.m_buf[pos] = (byte)nextByte;
                        ++pos;
                        continue;
                    }
                    byte[] tempBuf = new byte[pos];
                    System.arraycopy(this.m_buf, 0, tempBuf, 0, pos);
                    this.m_buf = tempBuf;
                }
            }
            boolean endOfDataFound = true;
            if (this.m_buf.length == this.m_eodStr.length) {
                for (int i = 0; i < this.m_eodStr.length; ++i) {
                    if (this.m_buf[i] == this.m_eodStr[i]) continue;
                    endOfDataFound = false;
                    break;
                }
            }
            if (this.m_buf.length > 0) {
                byte[] tempBuf = new byte[this.m_buf.length - 1];
                System.arraycopy(this.m_buf, 1, tempBuf, 0, tempBuf.length);
                byteRead = this.m_buf[0] & 0xFF;
                if (endOfDataFound) {
                    this.m_buf = tempBuf;
                } else {
                    int readAheadByte = this.readAhead();
                    if (readAheadByte != -1) {
                        System.arraycopy(tempBuf, 0, this.m_buf, 0, tempBuf.length);
                        this.m_buf[this.m_buf.length - 1] = (byte)readAheadByte;
                    } else {
                        this.m_buf = tempBuf;
                    }
                }
            }
        } else {
            byteRead = this.readAhead();
        }
        return byteRead;
    }

    public synchronized int read(byte[] a_buffer, int a_offset, int a_length) throws IOException {
        int bytesRead = 0;
        boolean endOfStreamReached = false;
        while (!endOfStreamReached && bytesRead < a_length) {
            int currentByte = this.read();
            if (currentByte == -1) {
                endOfStreamReached = true;
                continue;
            }
            a_buffer[a_offset + bytesRead] = (byte)currentByte;
            ++bytesRead;
        }
        if (endOfStreamReached && bytesRead == 0) {
            bytesRead = -1;
        }
        return bytesRead;
    }

    public synchronized int available() throws IOException {
        int availableBytes = 0;
        availableBytes = this.m_eodStr == null ? this.m_oldBuf.length + this.m_underlyingStream.available() : (this.m_buf == null ? Math.max(0, Math.min(this.m_eodStr.length, this.m_oldBuf.length + this.m_underlyingStream.available() - this.m_eodStr.length)) : Math.min(this.m_buf.length, this.m_oldBuf.length + this.m_underlyingStream.available()));
        return availableBytes;
    }

    public synchronized void setTerminator(byte[] a_terminator, int[] a_searchOptimizer) {
        this.m_eodStr = a_terminator;
        if (this.m_buf != null) {
            byte[] tempBuf = new byte[this.m_oldBuf.length + this.m_buf.length];
            System.arraycopy(this.m_oldBuf, 0, tempBuf, 0, this.m_oldBuf.length);
            System.arraycopy(this.m_buf, 0, tempBuf, this.m_oldBuf.length, this.m_buf.length);
            this.m_oldBuf = tempBuf;
        }
        this.m_buf = null;
    }

    public synchronized boolean atEnd() {
        boolean eodReached = false;
        if (this.m_eodStr != null && this.m_buf != null && !this.m_endOfUnderlyingStreamReached && this.m_buf.length == 0) {
            eodReached = true;
        }
        return eodReached;
    }

    public synchronized boolean startsWithCRLF() throws IOException {
        boolean startsWithCRLF = false;
        if (this.m_buf != null && this.m_buf.length > 0) {
            if (this.m_buf[0] == 13) {
                if (this.m_buf.length > 1) {
                    if (this.m_buf[1] == 10) {
                        startsWithCRLF = true;
                        this.read();
                        this.read();
                    }
                } else if (this.m_oldBuf.length > 0) {
                    if (this.m_oldBuf[0] == 10) {
                        startsWithCRLF = true;
                        this.readAhead();
                        this.read();
                    }
                } else {
                    int secondByte = this.m_underlyingStream.read();
                    if (secondByte != -1) {
                        if ((byte)secondByte == 10) {
                            startsWithCRLF = true;
                            this.read();
                        } else {
                            this.m_oldBuf = new byte[1];
                            this.m_oldBuf[0] = (byte)secondByte;
                        }
                    }
                }
            }
        } else if (this.m_oldBuf.length > 0) {
            if (this.m_oldBuf[0] == 13) {
                if (this.m_oldBuf.length > 1) {
                    if (this.m_oldBuf[1] == 10) {
                        startsWithCRLF = true;
                        this.readAhead();
                        this.readAhead();
                    }
                } else {
                    int secondByte = this.m_underlyingStream.read();
                    if (secondByte != -1) {
                        if ((byte)secondByte == 10) {
                            startsWithCRLF = true;
                            this.readAhead();
                        } else {
                            byte[] tempBuf = new byte[]{this.m_oldBuf[0], (byte)secondByte};
                            this.m_oldBuf = tempBuf;
                        }
                    }
                }
            }
        } else {
            int firstByte = this.m_underlyingStream.read();
            if (firstByte != -1) {
                if ((byte)firstByte == 13) {
                    int secondByte = this.m_underlyingStream.read();
                    if (secondByte != -1) {
                        if ((byte)secondByte == 10) {
                            startsWithCRLF = true;
                        } else {
                            this.m_oldBuf = new byte[2];
                            this.m_oldBuf[0] = (byte)firstByte;
                            this.m_oldBuf[1] = (byte)secondByte;
                        }
                    } else {
                        this.m_oldBuf = new byte[1];
                        this.m_oldBuf[0] = (byte)firstByte;
                    }
                } else {
                    this.m_oldBuf = new byte[1];
                    this.m_oldBuf[0] = (byte)firstByte;
                }
            }
        }
        return startsWithCRLF;
    }

    private synchronized int readAhead() throws IOException {
        int byteRead = -1;
        if (this.m_oldBuf.length > 0) {
            byte[] tempBuf = new byte[this.m_oldBuf.length - 1];
            System.arraycopy(this.m_oldBuf, 1, tempBuf, 0, tempBuf.length);
            byteRead = this.m_oldBuf[0] & 0xFF;
            this.m_oldBuf = tempBuf;
        } else {
            byteRead = this.m_underlyingStream.read();
            if (byteRead == -1) {
                this.m_endOfUnderlyingStreamReached = true;
            }
        }
        return byteRead;
    }
}

