/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.IDataChannelChipher;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class DataChannelCipherSDK
implements IDataChannelChipher {
    private Cipher m_sendEngine;
    private Cipher m_recvEngine;
    private long m_EncMsgCounter;
    private long m_DecMsgCounter;
    private SecretKeySpec m_sendKey;
    private SecretKeySpec m_recvKey;
    private byte[] m_sendIV;
    private byte[] m_recvIV;
    private boolean m_bSingleKey = false;
    private byte[] m_decryptHelperBuff = new byte[64];
    private static Constructor ms_constructorGCMSpec;
    private static Object[] ms_constructorargsGCMSpec;
    static /* synthetic */ Class array$B;

    public DataChannelCipherSDK() {
        this(null);
    }

    public DataChannelCipherSDK(String provider) {
        try {
            if (provider != null) {
                this.m_sendEngine = Cipher.getInstance("AES/GCM/NoPadding", provider);
                this.m_recvEngine = Cipher.getInstance("AES/GCM/NoPadding", provider);
            } else {
                this.m_sendEngine = Cipher.getInstance("AES/GCM/NoPadding");
                this.m_recvEngine = Cipher.getInstance("AES/GCM/NoPadding");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_sendIV = new byte[12];
        this.m_recvIV = new byte[12];
        this.m_EncMsgCounter = 0L;
        this.m_DecMsgCounter = 0L;
    }

    private synchronized int setSendKey(byte[] key, int offset, int len) {
        try {
            this.m_sendKey = new SecretKeySpec(key, offset, len, "AES");
            this.m_EncMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private synchronized int setRecvKey(byte[] key, int offset, int len) {
        try {
            this.m_recvKey = new SecretKeySpec(key, offset, len, "AES");
            this.m_DecMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] keys) {
        return this.setEncryptionKeysAES(keys, 0, keys.length);
    }

    public synchronized int setEncryptionKeysAES(byte[] keys, int offset, int keylen) {
        try {
            int ret2;
            int ret1;
            if (keylen == 16) {
                this.m_bSingleKey = true;
                ret1 = this.setSendKey(keys, offset, 16);
                ret2 = this.setRecvKey(keys, offset, 16);
            } else {
                this.m_bSingleKey = false;
                ret1 = this.setSendKey(keys, offset, 16);
                ret2 = this.setRecvKey(keys, offset + 16, 16);
            }
            if (ret1 == 0 && ret2 == 0) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public byte[] getKeys() {
        try {
            if (this.m_sendKey == null || this.m_recvKey == null) {
                return null;
            }
            if (this.m_bSingleKey) {
                return this.m_sendKey.getEncoded();
            }
            byte[] keys = new byte[32];
            System.arraycopy(this.m_sendKey.getEncoded(), 0, keys, 0, 16);
            System.arraycopy(this.m_recvKey.getEncoded(), 0, keys, 16, 16);
            return keys;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void createIV(byte[] iv, long counter) {
        iv[8] = (byte)(counter >> 24 & 0xFFL);
        iv[9] = (byte)(counter >> 16 & 0xFFL);
        iv[10] = (byte)(counter >> 8 & 0xFFL);
        iv[11] = (byte)(counter & 0xFFL);
    }

    private static AlgorithmParameterSpec createGCMParameterSpec(byte[] iv) {
        try {
            DataChannelCipherSDK.ms_constructorargsGCMSpec[1] = iv;
            return (AlgorithmParameterSpec)ms_constructorGCMSpec.newInstance(ms_constructorargsGCMSpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void encryptGCM1(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        DataChannelCipherSDK.createIV(this.m_sendIV, this.m_EncMsgCounter);
        ++this.m_EncMsgCounter;
        AlgorithmParameterSpec spec = DataChannelCipherSDK.createGCMParameterSpec(this.m_sendIV);
        this.m_sendEngine.init(1, (Key)this.m_sendKey, spec);
        int outlen = this.m_sendEngine.update(from, ifrom, len, to, ito);
        this.m_sendEngine.doFinal(to, ito + outlen);
    }

    public void decryptGCM2(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        DataChannelCipherSDK.createIV(this.m_recvIV, this.m_DecMsgCounter);
        ++this.m_DecMsgCounter;
        AlgorithmParameterSpec spec = DataChannelCipherSDK.createGCMParameterSpec(this.m_recvIV);
        this.m_recvEngine.init(2, (Key)this.m_recvKey, spec);
        try {
            this.m_recvEngine.doFinal(from, ifrom, 32, this.m_decryptHelperBuff, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int payloadLen = this.m_decryptHelperBuff[0] << 8 & 0x3F00 | this.m_decryptHelperBuff[1] & 0xFF;
        System.arraycopy(this.m_decryptHelperBuff, 0, to, ito, 32);
        int declen = this.m_recvEngine.update(from, ifrom + 32, payloadLen + 19, to, ito + 32);
        this.m_recvEngine.doFinal(to, ito + declen + 16);
    }

    public static int getMACSize() {
        return 16;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class<?> c = Class.forName("javax.crypto.spec.GCMParameterSpec");
            Class[] args = new Class[]{Integer.TYPE, array$B == null ? (array$B = DataChannelCipherSDK.class$("[B")) : array$B};
            ms_constructorGCMSpec = c.getConstructor(args);
            ms_constructorargsGCMSpec = new Object[2];
            DataChannelCipherSDK.ms_constructorargsGCMSpec[0] = new Integer(128);
        }
        catch (Exception e) {
            ms_constructorGCMSpec = null;
            e.printStackTrace();
        }
    }
}

