/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import logging.LogHolder;
import logging.LogType;

public final class ByteSignature {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ByteSignature() {
    }

    public static boolean verify(byte[] a_message, byte[] a_signature, AsymmetricCryptoKeyPair a_keyPair) {
        return ByteSignature.verify(a_message, a_signature, a_keyPair.getPublic());
    }

    public static boolean verify(byte[] a_message, byte[] a_signature, IMyPublicKey a_publicKey) {
        if (a_publicKey == null) {
            LogHolder.log(7, LogType.CRYPTO, "key==null!");
            return false;
        }
        ISignatureVerificationAlgorithm algorithm = a_publicKey.getSignatureAlgorithm();
        if (algorithm == null) {
            LogHolder.log(2, LogType.CRYPTO, "Try to verify a message - unknown algorithm!");
            return false;
        }
        return algorithm.verify(a_message, a_signature);
    }

    public static byte[] sign(byte[] a_message, AsymmetricCryptoKeyPair a_keyPair) {
        return ByteSignature.sign(a_message, a_keyPair.getPrivate());
    }

    public static byte[] sign(byte[] a_message, IMyPrivateKey a_privateKey) {
        if (a_privateKey == null) {
            return null;
        }
        return a_privateKey.getSignatureAlgorithm().sign(a_message);
    }

    public static String toHexString(byte[] a_bytes) {
        int currentValue;
        if (a_bytes == null || a_bytes.length == 0) {
            return "";
        }
        char[] value = new char[a_bytes.length * 3 - 1];
        int j = 0;
        for (int i = 0; i < a_bytes.length - 1; ++i) {
            currentValue = 0xFF & a_bytes[i];
            value[j++] = HEX_CHARS[currentValue >> 4];
            value[j++] = HEX_CHARS[currentValue & 0xF];
            value[j++] = 58;
        }
        currentValue = 0xFF & a_bytes[a_bytes.length - 1];
        value[j++] = HEX_CHARS[currentValue >> 4];
        value[j++] = HEX_CHARS[currentValue & 0xF];
        return new String(value);
    }
}

