/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.JAPCertificate;
import anon.crypto.SignatureVerifier;
import anon.util.ResourceLoader;
import java.util.Enumeration;
import logging.LogHolder;
import logging.LogType;

public class CryptoUtil {
    public static void addDefaultCertificates(String a_certspath, int a_type, String a_ignoreCertMark) {
        CryptoUtil.addDefaultCertificates(a_certspath, null, a_type, a_ignoreCertMark);
    }

    public static void addDefaultCertificates(String a_certspath, int a_type) {
        CryptoUtil.addDefaultCertificates(a_certspath, null, a_type, null);
    }

    public static void addDefaultCertificates(String a_certspath, String[] a_singleCerts, int a_type) {
        CryptoUtil.addDefaultCertificates(a_certspath, a_singleCerts, a_type, null);
    }

    public static void addDefaultCertificates(String a_certspath, String[] a_singleCerts, int a_type, String a_ignoreCertMark) {
        JAPCertificate defaultRootCert = null;
        if (a_singleCerts != null) {
            for (int i = 0; i < a_singleCerts.length; ++i) {
                byte[] res;
                if (a_singleCerts[i] == null || a_ignoreCertMark != null && a_singleCerts[i].endsWith(a_ignoreCertMark) || (defaultRootCert = JAPCertificate.getInstance(res = ResourceLoader.loadResource("certificates/" + a_certspath + a_singleCerts[i]))) == null) continue;
                SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(defaultRootCert, a_type, true, true);
            }
        }
        Enumeration certificates = JAPCertificate.getInstance("certificates/" + a_certspath, true, a_ignoreCertMark).elements();
        while (certificates.hasMoreElements()) {
            defaultRootCert = (JAPCertificate)certificates.nextElement();
            SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(defaultRootCert, a_type, true, true);
        }
        if (defaultRootCert == null) {
            LogHolder.log(3, LogType.MISC, "Error loading certificates of type '" + a_type + "'.");
        }
    }
}

