/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyDSASignature;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyRSASignature;
import anon.crypto.tinytls.TLSException;
import anon.crypto.tinytls.TLSHandshakeRecord;
import anon.crypto.tinytls.TLSPlaintextRecord;
import anon.crypto.tinytls.ciphersuites.CipherSuite;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_3DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_AES_128_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_DSS_WITH_DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_3DES_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_AES_128_CBC_SHA;
import anon.crypto.tinytls.ciphersuites.DHE_RSA_WITH_DES_CBC_SHA;
import anon.crypto.tinytls.util.hash;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.shared.ProxyConnection;
import anon.util.ByteArrayUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class TinyTLS
extends Socket {
    public static byte[] PROTOCOLVERSION = new byte[]{3, 1};
    private static int PROTOCOLVERSION_SHORT = 769;
    private Vector m_supportedciphersuites;
    private CipherSuite m_selectedciphersuite = null;
    private TLSInputStream m_istream;
    private TLSOutputStream m_ostream;
    private boolean m_handshakecompleted;
    private boolean m_serverhellodone;
    private boolean m_certificaterequested;
    private JAPCertificate m_servercertificate;
    private IMyPublicKey m_trustedRoot;
    private boolean m_checkTrustedRoot;
    private byte[] m_clientrandom;
    private byte[] m_serverrandom;
    private byte[] m_handshakemessages;
    private byte[] m_clientcertificatetypes;
    private IMyPrivateKey m_clientprivatekey;
    private JAPCertificate[] m_clientcertificates;
    private boolean m_certificateverify;
    private boolean m_encrypt;
    private ProxyConnection m_ProxyConnection;

    public TinyTLS(String addr, int port) throws UnknownHostException, IOException, Exception {
        this(addr, port, null);
    }

    public TinyTLS(String addr, int port, ImmutableProxyInterface a_proxyInterface) throws UnknownHostException, IOException, Exception {
        this.m_ProxyConnection = new ProxyConnection(HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(addr, port), a_proxyInterface).Connect());
        this.m_handshakecompleted = false;
        this.m_serverhellodone = false;
        this.m_encrypt = false;
        this.m_certificaterequested = false;
        this.m_certificateverify = false;
        this.m_supportedciphersuites = new Vector();
        this.m_istream = new TLSInputStream(this.m_ProxyConnection.getInputStream());
        this.m_ostream = new TLSOutputStream(this.m_ProxyConnection.getOutputStream());
        this.m_trustedRoot = null;
        this.m_checkTrustedRoot = true;
        this.m_clientcertificatetypes = null;
        this.m_clientcertificates = null;
        this.m_clientprivatekey = null;
    }

    public void addCipherSuite(CipherSuite cs) {
        if (!this.m_supportedciphersuites.contains(cs)) {
            this.m_supportedciphersuites.addElement(cs);
            LogHolder.log(7, LogType.MISC, "[CIPHERSUITE_ADDED] : " + cs.toString());
        }
    }

    public void startHandshake() throws IOException {
        if (this.m_supportedciphersuites.isEmpty()) {
            LogHolder.log(7, LogType.MISC, "[NO_CIPHERSUITE_DEFINED] : using predefined");
            this.addCipherSuite(new DHE_RSA_WITH_AES_128_CBC_SHA());
            this.addCipherSuite(new DHE_DSS_WITH_AES_128_CBC_SHA());
            this.addCipherSuite(new DHE_RSA_WITH_3DES_CBC_SHA());
            this.addCipherSuite(new DHE_DSS_WITH_3DES_CBC_SHA());
            this.addCipherSuite(new DHE_RSA_WITH_DES_CBC_SHA());
            this.addCipherSuite(new DHE_DSS_WITH_DES_CBC_SHA());
        }
        if (!this.m_checkTrustedRoot) {
            LogHolder.log(7, LogType.MISC, "[CHECK_TRUSTED_ROOT_DEACTIVATED] : all certificates are accepted");
        } else if (this.m_trustedRoot == null) {
            LogHolder.log(7, LogType.MISC, "[TRUSTED_CERTIFICATES_NOT_SET] : cannot verify Certificates");
            throw new TLSException("Please set Trusted Root");
        }
        this.m_handshakemessages = new byte[0];
        this.m_ostream.sendClientHello();
        this.m_istream.readServerHandshakes();
        this.m_ostream.sendClientCertificate();
        this.m_ostream.sendClientKeyExchange();
        this.m_ostream.sendCertificateVerify();
        this.m_ostream.sendChangeCipherSpec();
        this.m_ostream.sendClientFinished();
        this.m_istream.readServerFinished();
        this.m_handshakecompleted = true;
    }

    public void setRootKey(IMyPublicKey rootKey) {
        this.m_trustedRoot = rootKey;
    }

    public void checkRootCertificate(boolean check) {
        this.m_checkTrustedRoot = check;
    }

    public InputStream getInputStream() {
        return this.m_istream;
    }

    public OutputStream getOutputStream() {
        return this.m_ostream;
    }

    public void setSoTimeout(int i) throws SocketException {
        this.m_ProxyConnection.setSoTimeout(i);
    }

    public void setClientCertificate(JAPCertificate cert, IMyPrivateKey key) throws IOException {
        this.setClientCertificate(new JAPCertificate[]{cert}, key);
    }

    public void setClientCertificate(JAPCertificate[] certificates, IMyPrivateKey key) throws IOException {
        if (certificates != null) {
            JAPCertificate prevCert = certificates[0];
            LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE] " + prevCert.getIssuer().toString());
            LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE] " + prevCert.getSubject().toString());
            for (int i = 1; i < certificates.length; ++i) {
                JAPCertificate cert = certificates[i];
                if (!prevCert.verify(cert.getPublicKey())) {
                    throw new IOException("TLS Server Certs could not be verified!");
                }
                prevCert = cert;
                LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE] " + prevCert.getIssuer().toString());
                LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE] " + prevCert.getSubject().toString());
            }
        }
        this.m_clientcertificates = certificates;
        this.m_clientprivatekey = key;
    }

    public void close() {
        try {
            if (this.m_ostream != null) {
                this.m_ostream.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.m_istream != null) {
                this.m_istream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_ProxyConnection.close();
    }

    public Socket getSocket() {
        return this.m_ProxyConnection.getSocket();
    }

    static /* synthetic */ byte[] access$202(TinyTLS x0, byte[] x1) {
        x0.m_serverrandom = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$902(TinyTLS x0, byte[] x1) {
        x0.m_clientcertificatetypes = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1202(TinyTLS x0, byte[] x1) {
        x0.m_handshakemessages = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(TinyTLS x0, byte[] x1) {
        x0.m_clientrandom = x1;
        return x1;
    }

    class TLSOutputStream
    extends OutputStream {
        private OutputStream m_stream;
        private TLSPlaintextRecord m_aktTLSRecord = new TLSPlaintextRecord();

        public TLSOutputStream(OutputStream ostream) {
            this.m_stream = ostream;
        }

        public void write(byte[] message) throws IOException {
            this.send(23, message, 0, message.length);
        }

        public void write(byte[] message, int offset, int len) throws IOException {
            this.send(23, message, offset, len);
        }

        public void write(int i) throws IOException {
            this.write(new byte[]{(byte)i});
        }

        public void close() throws IOException {
            this.sendCloseNotify();
            this.m_stream.close();
        }

        public void flush() throws IOException {
            this.m_stream.flush();
        }

        private synchronized void send(int type, byte[] message, int offset, int len) throws IOException {
            byte[] dataBuff = this.m_aktTLSRecord.getData();
            System.arraycopy(message, offset, dataBuff, 0, len);
            this.m_aktTLSRecord.setLength(len);
            this.m_aktTLSRecord.setType(type);
            if (TinyTLS.this.m_encrypt) {
                TinyTLS.this.m_selectedciphersuite.encode(this.m_aktTLSRecord);
            }
            this.m_stream.write(this.m_aktTLSRecord.getHeader());
            this.m_stream.write(dataBuff, 0, this.m_aktTLSRecord.getLength());
            this.m_stream.flush();
        }

        public void sendHandshake(int type, byte[] message) throws IOException {
            byte[] senddata = ByteArrayUtil.conc(new byte[]{(byte)type}, ByteArrayUtil.inttobyte(message.length, 3), message);
            this.send(22, senddata, 0, senddata.length);
            TinyTLS.access$1202(TinyTLS.this, ByteArrayUtil.conc(TinyTLS.this.m_handshakemessages, senddata));
        }

        public void sendClientHello() throws IOException {
            byte[] random = new byte[28];
            byte[] sessionid = new byte[]{0};
            byte[] ciphers = new byte[TinyTLS.this.m_supportedciphersuites.size() * 2];
            int counter = 0;
            for (int i = 0; i < TinyTLS.this.m_supportedciphersuites.size(); ++i) {
                CipherSuite cs = (CipherSuite)TinyTLS.this.m_supportedciphersuites.elementAt(i);
                ciphers[counter] = cs.getCipherSuiteCode()[0];
                ciphers[++counter] = cs.getCipherSuiteCode()[1];
                ++counter;
            }
            byte[] ciphersuites = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(TinyTLS.this.m_supportedciphersuites.size() * 2, 2), ciphers);
            byte[] compression = new byte[]{1, 0};
            byte[] gmt_unix_time = ByteArrayUtil.inttobyte(System.currentTimeMillis() / 1000L, 4);
            Random rand = new Random(System.currentTimeMillis());
            rand.nextBytes(random);
            byte[] message = ByteArrayUtil.conc(PROTOCOLVERSION, gmt_unix_time, random, sessionid, ciphersuites, compression);
            this.sendHandshake(1, message);
            TinyTLS.access$702(TinyTLS.this, ByteArrayUtil.conc(gmt_unix_time, random));
            LogHolder.log(7, LogType.MISC, "[CLIENT_HELLO]");
        }

        public void sendClientCertificate() throws IOException {
            LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE]");
            if (TinyTLS.this.m_certificaterequested) {
                if (TinyTLS.this.m_clientcertificatetypes != null && TinyTLS.this.m_clientcertificates != null) {
                    block5: for (int i = 0; i < TinyTLS.this.m_clientcertificatetypes.length; ++i) {
                        switch (TinyTLS.this.m_clientcertificatetypes[i]) {
                            case 1: {
                                byte[] b = new byte[]{};
                                for (int i2 = 0; i2 < TinyTLS.this.m_clientcertificates.length; ++i2) {
                                    byte[] cert = TinyTLS.this.m_clientcertificates[i2].toByteArray(false);
                                    b = ByteArrayUtil.conc(b, ByteArrayUtil.inttobyte(cert.length, 3), cert);
                                }
                                b = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(b.length, 3), b);
                                this.sendHandshake(11, b);
                                TinyTLS.this.m_certificateverify = true;
                                return;
                            }
                            case 2: {
                                byte[] b = new byte[]{};
                                for (int i2 = 0; i2 < TinyTLS.this.m_clientcertificates.length; ++i2) {
                                    byte[] cert = TinyTLS.this.m_clientcertificates[i2].toByteArray(false);
                                    b = ByteArrayUtil.conc(b, ByteArrayUtil.inttobyte(cert.length, 3), cert);
                                }
                                b = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(b.length, 3), b);
                                this.sendHandshake(11, b);
                                TinyTLS.this.m_certificateverify = true;
                                return;
                            }
                            case 3: {
                                continue block5;
                            }
                        }
                    }
                } else {
                    this.sendHandshake(11, new byte[]{0, 0, 0});
                }
            }
        }

        public void sendClientKeyExchange() throws IOException {
            byte[] message = TinyTLS.this.m_selectedciphersuite.calculateClientKeyExchange();
            this.sendHandshake(16, ByteArrayUtil.conc(ByteArrayUtil.inttobyte(message.length, 2), message));
            LogHolder.log(7, LogType.MISC, "[CLIENT_KEY_EXCHANGE]");
        }

        public void sendCertificateVerify() throws IOException {
            if (TinyTLS.this.m_certificateverify) {
                if (TinyTLS.this.m_clientprivatekey instanceof MyRSAPrivateKey) {
                    byte[] signature = ByteArrayUtil.conc(hash.md5(TinyTLS.this.m_handshakemessages), hash.sha(TinyTLS.this.m_handshakemessages));
                    MyRSASignature sig = new MyRSASignature();
                    try {
                        sig.initSign(TinyTLS.this.m_clientprivatekey);
                    }
                    catch (InvalidKeyException ex) {
                        throw new TLSException("cannot encrypt signature", 2, 80);
                    }
                    byte[] signature2 = sig.signPlain(signature);
                    signature2 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(signature2.length, 2), signature2);
                    this.sendHandshake(15, signature2);
                    LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE_VERIFY_RSA]");
                } else if (TinyTLS.this.m_clientprivatekey instanceof MyDSAPrivateKey) {
                    MyDSASignature sig = new MyDSASignature();
                    try {
                        sig.initSign(TinyTLS.this.m_clientprivatekey);
                    }
                    catch (InvalidKeyException ex) {
                        // empty catch block
                    }
                    byte[] signature2 = sig.sign(TinyTLS.this.m_handshakemessages);
                    signature2 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(signature2.length, 2), signature2);
                    this.sendHandshake(15, signature2);
                    LogHolder.log(7, LogType.MISC, "[CLIENT_CERTIFICATE_VERIFY_DSA]");
                }
            }
        }

        public void sendChangeCipherSpec() throws IOException {
            this.send(20, new byte[]{1}, 0, 1);
            TinyTLS.this.m_encrypt = true;
            LogHolder.log(7, LogType.MISC, "[CLIENT_CHANGE_CIPHER_SPEC]");
        }

        public void sendCloseNotify() throws IOException {
            this.send(21, new byte[]{1, 0}, 0, 2);
            LogHolder.log(7, LogType.MISC, "[CLIENT_CLOSE_NOTIFY]");
        }

        public void sendClientFinished() throws IOException {
            this.sendHandshake(20, TinyTLS.this.m_selectedciphersuite.getKeyExchangeAlgorithm().calculateClientFinished(TinyTLS.this.m_handshakemessages));
            LogHolder.log(7, LogType.MISC, "[CLIENT_FINISHED]");
        }
    }

    class TLSInputStream
    extends InputStream
    implements ITLSConstants {
        private DataInputStream m_stream;
        private int m_aktPendOffset;
        private int m_aktPendLen;
        private TLSPlaintextRecord m_aktTLSRecord = new TLSPlaintextRecord();
        private int m_ReadRecordState;

        public TLSInputStream(InputStream istream) {
            this.m_stream = new DataInputStream(istream);
            this.m_aktPendOffset = 0;
            this.m_aktPendLen = 0;
            this.m_ReadRecordState = 0;
        }

        private synchronized void readRecord() throws IOException {
            if (this.m_ReadRecordState == 0) {
                byte contenttype;
                this.m_aktTLSRecord.clean();
                try {
                    contenttype = this.m_stream.readByte();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                if (contenttype < 20 || contenttype > 23) {
                    throw new TLSException("SSL Content typeProtocoll not supported: " + contenttype);
                }
                this.m_aktTLSRecord.setType(contenttype);
                this.m_ReadRecordState = 1;
            }
            if (this.m_ReadRecordState == 1) {
                short version;
                try {
                    version = this.m_stream.readShort();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                if (version != PROTOCOLVERSION_SHORT) {
                    throw new TLSException("Protocol version not supported: " + version);
                }
                this.m_ReadRecordState = 2;
            }
            if (this.m_ReadRecordState == 2) {
                short length = 0;
                try {
                    length = this.m_stream.readShort();
                }
                catch (InterruptedIOException ioe) {
                    ioe.bytesTransferred = 0;
                    throw ioe;
                }
                if (length > 16384) {
                    throw new TLSException("Given size of TLSPlaintext record payload exceeds TLSPlaintextRecord.MAX_PAYLOAD_SIZE!");
                }
                this.m_aktTLSRecord.setLength(length);
                this.m_ReadRecordState = 3;
                this.m_aktPendOffset = 0;
            }
            if (this.m_ReadRecordState == 3) {
                int len = this.m_aktTLSRecord.getLength() - this.m_aktPendOffset;
                while (len > 0) {
                    try {
                        byte[] buff = this.m_aktTLSRecord.getData();
                        int ret = this.m_stream.read(buff, this.m_aktPendOffset, len);
                        if (ret < 0) {
                            throw new EOFException();
                        }
                        len -= ret;
                        this.m_aktPendOffset += ret;
                    }
                    catch (InterruptedIOException ioe) {
                        this.m_aktPendOffset += ioe.bytesTransferred;
                        ioe.bytesTransferred = 0;
                        throw ioe;
                    }
                }
                this.m_ReadRecordState = 0;
                this.m_aktPendOffset = 0;
            }
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) < 1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            block6: while (this.m_aktPendLen < 1) {
                this.readRecord();
                try {
                    switch (this.m_aktTLSRecord.getType()) {
                        case 23: {
                            TinyTLS.this.m_selectedciphersuite.decode(this.m_aktTLSRecord);
                            this.m_aktPendOffset = 0;
                            this.m_aktPendLen = this.m_aktTLSRecord.getLength();
                            continue block6;
                        }
                        case 21: {
                            this.handleAlert();
                            continue block6;
                        }
                    }
                    throw new IOException("Error while decoding application data");
                }
                catch (Throwable t) {
                    throw new IOException("Exception by reading next TSL record: " + t.getMessage());
                }
            }
            int l = Math.min(this.m_aktPendLen, len);
            System.arraycopy(this.m_aktTLSRecord.getData(), this.m_aktPendOffset, b, off, l);
            this.m_aktPendOffset += l;
            this.m_aktPendLen -= l;
            return l;
        }

        public int available() {
            return this.m_aktPendLen;
        }

        private void gotServerHello(TLSHandshakeRecord msg) throws IOException {
            byte[] b;
            int aktIndex = 0;
            byte[] dataBuff = msg.getData();
            LogHolder.log(7, LogType.MISC, "[SERVER_HELLO] SSLVERSION :" + dataBuff[aktIndex] + "." + dataBuff[aktIndex + 1]);
            if (dataBuff[aktIndex] != PROTOCOLVERSION[0] || dataBuff[aktIndex + 1] != PROTOCOLVERSION[1]) {
                throw new TLSException("Server replies with wrong protocol");
            }
            TinyTLS.access$202(TinyTLS.this, ByteArrayUtil.copy(dataBuff, aktIndex + 2, 32));
            byte[] sessionid = new byte[]{};
            byte sessionidlength = dataBuff[aktIndex + 34];
            if (sessionidlength > 0) {
                sessionid = ByteArrayUtil.copy(dataBuff, aktIndex + 35, sessionidlength);
            }
            LogHolder.log(7, LogType.MISC, "[SERVER_HELLO] Laenge der SessionID : " + sessionidlength);
            byte[] ciphersuite = ByteArrayUtil.copy(dataBuff, aktIndex + 35 + sessionidlength, 2);
            LogHolder.log(7, LogType.MISC, "[SERVER_HELLO] Ciphersuite : " + ciphersuite[0] + " " + ciphersuite[1]);
            byte[] compression = ByteArrayUtil.copy(dataBuff, aktIndex + 37 + sessionidlength, 1);
            LogHolder.log(7, LogType.MISC, "[SERVER_HELLO] Kompression : " + compression[0]);
            CipherSuite cs = null;
            for (int i = 0; i < TinyTLS.this.m_supportedciphersuites.size() && ((b = (cs = (CipherSuite)TinyTLS.this.m_supportedciphersuites.elementAt(i)).getCipherSuiteCode())[0] != ciphersuite[0] || b[1] != ciphersuite[1]); ++i) {
                cs = null;
            }
            if (cs == null) {
                throw new TLSException("Unsupported Ciphersuite selected");
            }
            TinyTLS.this.m_selectedciphersuite = cs;
            TinyTLS.this.m_supportedciphersuites = null;
        }

        private void gotCertificate(TLSHandshakeRecord msg) throws IOException {
            byte[] bytes = msg.getData();
            int offset = 0;
            int len = msg.getLength();
            Vector<JAPCertificate> certificates = new Vector<JAPCertificate>();
            byte[] b = ByteArrayUtil.copy(bytes, offset, 3);
            int certificateslength = (b[0] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[2] & 0xFF;
            int pos = offset + 3;
            b = ByteArrayUtil.copy(bytes, pos, 3);
            int certificatelength = (b[0] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[2] & 0xFF;
            b = ByteArrayUtil.copy(bytes, pos += 3, certificatelength);
            pos += certificatelength;
            JAPCertificate japcert = JAPCertificate.getInstance(b);
            LogHolder.log(7, LogType.MISC, "[SERVER_CERTIFICATE] " + japcert.getIssuer().toString());
            LogHolder.log(7, LogType.MISC, "[SERVER_CERTIFICATE] " + japcert.getSubject().toString());
            TinyTLS.this.m_servercertificate = japcert;
            TinyTLS.this.m_selectedciphersuite.setServerCertificate(japcert);
            while (pos - offset < certificateslength) {
                b = ByteArrayUtil.copy(bytes, pos, 3);
                certificatelength = (b[0] & 0xFF) << 16 | (b[1] & 0xFF) << 8 | b[2] & 0xFF;
                b = ByteArrayUtil.copy(bytes, pos += 3, certificatelength);
                pos += certificatelength;
                japcert = JAPCertificate.getInstance(b);
                LogHolder.log(7, LogType.MISC, "[NEXT_CERTIFICATE] " + japcert.getIssuer().toString());
                LogHolder.log(7, LogType.MISC, "[NEXT_CERTIFICATE] " + japcert.getSubject().toString());
                certificates.addElement(japcert);
            }
            JAPCertificate prevCert = TinyTLS.this.m_servercertificate;
            for (int i = 0; i < certificates.size(); ++i) {
                JAPCertificate cert = (JAPCertificate)certificates.elementAt(i);
                if (!prevCert.verify(cert.getPublicKey())) {
                    throw new IOException("TLS Server Certs could not be verified!");
                }
                prevCert = cert;
            }
            if (TinyTLS.this.m_checkTrustedRoot && !prevCert.verify(TinyTLS.this.m_trustedRoot)) {
                throw new IOException("TLS Server Cert could not be verified to be trusted!");
            }
        }

        private void gotServerKeyExchange(TLSHandshakeRecord msg) throws IOException {
            byte[] bytes = msg.getData();
            int offset = 0;
            int len = msg.getLength();
            TinyTLS.this.m_selectedciphersuite.getKeyExchangeAlgorithm().processServerKeyExchange(bytes, offset, len, TinyTLS.this.m_clientrandom, TinyTLS.this.m_serverrandom, TinyTLS.this.m_servercertificate);
        }

        private void gotCertificateRequest(TLSHandshakeRecord msg) {
            byte[] bytes = msg.getData();
            int offset = 0;
            int len = msg.getLength();
            TinyTLS.this.m_certificaterequested = true;
            LogHolder.log(7, LogType.MISC, "[SERVER_CERTIFICATE_REQUEST]");
            byte length = bytes[offset];
            if (length > 0) {
                TinyTLS.access$902(TinyTLS.this, ByteArrayUtil.copy(bytes, offset + 1, length));
            }
        }

        private void gotServerHelloDone() {
            TinyTLS.this.m_serverhellodone = true;
            LogHolder.log(7, LogType.MISC, "[SERVER_HELLO_DONE]");
        }

        private void handleAlert() throws TLSException {
            LogHolder.log(7, LogType.MISC, "[TLS] ALERT!");
            if (TinyTLS.this.m_handshakecompleted) {
                TinyTLS.this.m_selectedciphersuite.decode(this.m_aktTLSRecord);
            }
            byte[] payload = this.m_aktTLSRecord.getData();
            block0 : switch (payload[0]) {
                case 1: {
                    switch (payload[1]) {
                        case 0: {
                            LogHolder.log(7, LogType.MISC, "[RECIEVED-ALERT] TYPE=WARNING ; MESSAGE=CLOSE NOTIFY");
                            break block0;
                        }
                    }
                    throw new TLSException("TLSAlert detected!! Level : Warning - Description :" + payload[1]);
                }
                case 2: {
                    throw new TLSException("TLSAlert detected!! Level : Fatal - Description :" + payload[1]);
                }
                default: {
                    throw new TLSException("Unknown TLSAlert detected!!");
                }
            }
        }

        protected void readServerHandshakes() throws IOException {
            block11: while (!TinyTLS.this.m_serverhellodone) {
                if (!this.m_aktTLSRecord.hasMoreHandshakeRecords()) {
                    this.readRecord();
                    switch (this.m_aktTLSRecord.getType()) {
                        case 21: {
                            this.handleAlert();
                            break;
                        }
                        case 22: {
                            break;
                        }
                        default: {
                            throw new TLSException("Error while shaking hands");
                        }
                    }
                }
                TLSHandshakeRecord handshakeRecord = this.m_aktTLSRecord.getNextHandshakeRecord();
                byte[] dataBuff = handshakeRecord.getData();
                int type = handshakeRecord.getType();
                int length = handshakeRecord.getLength();
                TinyTLS.access$1202(TinyTLS.this, ByteArrayUtil.conc(TinyTLS.this.m_handshakemessages, handshakeRecord.getHeader(), 4));
                TinyTLS.access$1202(TinyTLS.this, ByteArrayUtil.conc(TinyTLS.this.m_handshakemessages, dataBuff, length));
                switch (type) {
                    case 2: {
                        this.gotServerHello(handshakeRecord);
                        continue block11;
                    }
                    case 11: {
                        this.gotCertificate(handshakeRecord);
                        continue block11;
                    }
                    case 12: {
                        this.gotServerKeyExchange(handshakeRecord);
                        continue block11;
                    }
                    case 13: {
                        this.gotCertificateRequest(handshakeRecord);
                        continue block11;
                    }
                    case 14: {
                        this.gotServerHelloDone();
                        continue block11;
                    }
                }
                throw new TLSException("Unexpected Handshake type: " + type);
            }
        }

        protected void readServerFinished() throws IOException {
            this.readRecord();
            switch (this.m_aktTLSRecord.getType()) {
                case 20: {
                    if (this.m_aktTLSRecord.getLength() != 1 || this.m_aktTLSRecord.getData()[0] != 1) break;
                    LogHolder.log(7, LogType.MISC, "[SERVER_CHANGE_CIPHER_SPEC]");
                    break;
                }
                case 21: {
                    this.handleAlert();
                    break;
                }
                default: {
                    throw new TLSException("Error while shaking hands");
                }
            }
            this.readRecord();
            switch (this.m_aktTLSRecord.getType()) {
                case 22: {
                    LogHolder.log(7, LogType.MISC, "[SERVER_FINISHED]");
                    TinyTLS.this.m_selectedciphersuite.processServerFinished(this.m_aktTLSRecord, TinyTLS.this.m_handshakemessages);
                    break;
                }
                case 21: {
                    this.handleAlert();
                    break;
                }
                default: {
                    throw new TLSException("Error while shaking hands");
                }
            }
        }
    }

    private static interface ITLSConstants {
        public static final int STATE_START = 0;
        public static final int STATE_VERSION = 1;
        public static final int STATE_LENGTH = 2;
        public static final int STATE_PAYLOAD = 3;
    }
}

