/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.IDistributable;
import anon.infoservice.IDistributor;
import anon.infoservice.ListenerInterface;
import anon.infoservice.update.AccountUpdater;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.JAPMessages;
import anon.util.ThreadPool;
import anon.util.TimedOutputStream;
import anon.util.XMLParseException;
import infoservice.Configuration;
import infoservice.InfoServiceCommands;
import infoservice.InfoServiceDistributor;
import infoservice.InfoServicePropagandist;
import infoservice.InfoServiceServer;
import infoservice.JWSInternalCommands;
import infoservice.KeyGenTest;
import infoservice.PassiveInfoServiceInitializer;
import infoservice.performance.PerformanceMeter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import logging.LogHolder;
import logging.LogType;

public class InfoService
implements Observer {
    public static final String INFOSERVICE_VERSION = "IS.09.010";
    protected JWSInternalCommands oicHandler;
    private static int m_connectionCounter;
    private static PerformanceMeter ms_perfMeter;
    private static AccountUpdater ms_accountUpdater;
    private String m_configFileName;
    protected ThreadPool m_ThreadPool;

    public static void main(String[] argv) {
        String fn = null;
        String strPasswd = null;
        if (argv.length >= 1) {
            fn = argv[0].trim();
        }
        if (fn != null) {
            if (fn.equalsIgnoreCase("--generatekey")) {
                String isName = null;
                String passwd = null;
                try {
                    for (int i = 1; i < argv.length; ++i) {
                        String arg = argv[i].trim();
                        if (arg.equals("--name")) {
                            isName = argv[++i].trim();
                            continue;
                        }
                        if (!arg.equals("--passwd")) continue;
                        passwd = argv[++i].trim();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                InfoService.generateKeyPair(isName, passwd);
                System.exit(0);
            } else if (fn.equalsIgnoreCase("--version")) {
                System.out.println("InfoService version: IS.09.010");
                System.exit(0);
            } else if (fn.equalsIgnoreCase("--password")) {
                strPasswd = argv[1].trim();
                fn = argv.length > 2 ? argv[2].trim() : null;
            }
        }
        try {
            InfoService s1 = new InfoService(fn, strPasswd);
            s1.startServer();
            if (Configuration.getInstance().isPerfEnabled()) {
                LogHolder.log(5, LogType.NET, "Starting Performance Meter...");
                ms_accountUpdater = new AccountUpdater(false);
                ms_accountUpdater.start(false);
                ms_perfMeter = new PerformanceMeter(ms_accountUpdater);
                Thread perfMeterThread = new Thread(ms_perfMeter);
                perfMeterThread.start();
            } else {
                ms_perfMeter = null;
            }
            JAPMessages.setLocale(Locale.ENGLISH);
            System.out.println("InfoService is running!");
            Thread tacLoader = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(18000000L);
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        try {
                            InfoService.loadTemplatesFromDirectory(Configuration.getInstance().getTermsAndConditionsDir());
                        }
                        catch (SignatureException e) {
                            LogHolder.log(0, LogType.CRYPTO, e);
                        }
                    }
                }
            };
            InfoService.loadTemplatesFromDirectory(Configuration.getInstance().getTermsAndConditionsDir());
            tacLoader.start();
        }
        catch (Exception e) {
            System.out.println("Cannot start InfoService...");
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void update(Observable a_ob, Object a_args) {
        if (a_args == null || a_args.toString() == null) {
            return;
        }
        String signal = a_args.toString();
        if (signal.equals("SIGHUP")) {
            System.out.println("Reloading configuration...");
            LogHolder.log(1, LogType.ALL, "Caught SIGHUP. Reloading config...");
            try {
                this.loadConfig(null);
                ms_perfMeter.init();
            }
            catch (Exception ex) {
                System.out.println("Could not load configuration. Exiting...");
                LogHolder.log(1, LogType.ALL, "Could not load configuration. Exiting...");
            }
        }
        if (signal.equals("SIGTERM")) {
            System.out.println("Exiting...");
            LogHolder.log(1, LogType.ALL, "Caught SIGTERM. Exiting...");
            this.stopServer();
            System.exit(1);
        }
    }

    private static void generateKeyPair(String isName, String passwd) {
        try {
            System.out.println("Start generating new KeyPair (this can take some minutes)...");
            KeyGenTest.generateKeys(isName, passwd);
            System.out.println("Finished generating new KeyPair!");
        }
        catch (Exception e) {
            System.out.println("Error generating KeyPair!");
            e.printStackTrace();
        }
    }

    private InfoService(String a_configFileName, String strPasswd) throws Exception {
        this.m_configFileName = a_configFileName;
        this.loadConfig(strPasswd);
        m_connectionCounter = 0;
    }

    public static void loadTemplatesFromDirectory(File a_dir) throws SignatureException {
        File file = null;
        if (a_dir == null) {
            return;
        }
        String[] files = a_dir.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            try {
                file = new File(a_dir.getAbsolutePath() + File.separator + files[i]);
                TermsAndConditionsTemplate tac = new TermsAndConditionsTemplate(file);
                if (!tac.isVerified()) {
                    throw new SignatureException("Cannot verify tac template file: " + tac.getId());
                }
                Database.getInstance(TermsAndConditionsTemplate.class).update(tac);
                continue;
            }
            catch (XMLParseException ex) {
                LogHolder.log(2, LogType.MISC, "XMLParseException while loading Terms & Conditions: ", ex);
                continue;
            }
            catch (IOException ex) {
                LogHolder.log(2, LogType.MISC, "IOException while loading Terms & Conditions: ", ex);
            }
        }
    }

    private void loadConfig(String strPasswd) throws Exception {
        Properties properties = new Properties();
        if (this.m_configFileName == null) {
            this.m_configFileName = "InfoService.properties";
        }
        try {
            properties.load(new FileInputStream(this.m_configFileName));
        }
        catch (Exception a_e) {
            System.out.println("Error reading configuration!");
            System.out.println(a_e.getMessage());
            System.exit(1);
        }
        new Configuration(properties, strPasswd);
    }

    private void startServer() throws Exception {
        HTTPConnectionFactory.getInstance().setTimeout(30000);
        this.oicHandler = new InfoServiceCommands();
        if (!Configuration.getInstance().isPassive()) {
            InfoServicePropagandist.generateInfoServicePropagandist(ms_perfMeter);
            Database.registerDistributor(InfoServiceDistributor.getInstance());
        } else {
            Database.registerDistributor(new IDistributor(){

                @Override
                public void addJob(IDistributable a_distributable) {
                }
            });
            PassiveInfoServiceInitializer.init();
        }
        LogHolder.log(0, LogType.MISC, "InfoService -- Version IS.09.010");
        LogHolder.log(0, LogType.MISC, System.getProperty("java.version"));
        LogHolder.log(0, LogType.MISC, System.getProperty("java.vendor"));
        LogHolder.log(0, LogType.MISC, System.getProperty("java.home"));
        LogHolder.log(0, LogType.MISC, System.getProperty("os.name"));
        LogHolder.log(0, LogType.MISC, System.getProperty("os.arch"));
        LogHolder.log(0, LogType.MISC, System.getProperty("os.version"));
        this.m_ThreadPool = new ThreadPool("ISConnection", Configuration.getInstance().getNrOfConcurrentConnections());
        TimedOutputStream.init();
        Enumeration<ListenerInterface> enumer = Configuration.getInstance().getHardwareListeners().elements();
        while (enumer.hasMoreElements()) {
            InfoServiceServer server = new InfoServiceServer(enumer.nextElement(), this);
            Thread currentThread = new Thread((Runnable)server, server.toString());
            currentThread.setDaemon(true);
            currentThread.start();
        }
    }

    private void stopServer() {
    }

    protected static int getConnectionCounter() {
        return m_connectionCounter++;
    }

    protected static PerformanceMeter getPerfMeter() {
        return ms_perfMeter;
    }
}

