/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.HttpResponseStructure;
import anon.util.SocketGuard;
import anon.util.TimedOutputStream;
import infoservice.Configuration;
import infoservice.ISRuntimeStatistics;
import infoservice.JWSInternalCommands;
import java.io.ByteArrayOutputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class InfoServiceConnection
implements Runnable {
    private static final int RESPONSE_CHUNK_SIZE = 5000;
    private static boolean ms_bLogAnonlibVersion = false;
    private SocketGuard m_socket;
    private int m_connectionId;
    private JWSInternalCommands m_serverImplementation;
    private int m_byteLimit;
    private ByteArrayOutputStream m_tmpByteArrayOut;

    public InfoServiceConnection(SocketGuard a_socket, int a_connectionId, JWSInternalCommands a_serverImplementation) {
        this.m_socket = a_socket;
        this.m_connectionId = a_connectionId;
        this.m_serverImplementation = a_serverImplementation;
        this.m_tmpByteArrayOut = new ByteArrayOutputStream(512);
    }

    @Override
    public void run() {
        try {
            HttpResponseStructure response;
            try {
                this.m_socket.setSoTimeout(30000);
            }
            catch (Exception e) {
                LogHolder.log(4, LogType.NET, "InfoServiceConnection (" + Integer.toString(this.m_connectionId) + "): Cannot set socket timeout: " + e.toString());
            }
            int internalRequestMethodCode = 0;
            String requestMethod = null;
            String requestUrl = null;
            byte[] postData = null;
            int supportedEncodings = 0;
            try {
                boolean bStatisticsHeaderFound;
                String requestLine;
                this.initReader(10000);
                try {
                    requestLine = this.readRequestLine();
                }
                catch (SocketException a_e) {
                    LogHolder.log(5, LogType.NET, "No client request received. " + a_e.getMessage());
                    requestLine = null;
                }
                catch (SocketTimeoutException a_e) {
                    LogHolder.log(4, LogType.NET, "Client request timed out. " + a_e.getMessage());
                    requestLine = null;
                }
                if (requestLine == null) {
                    this.closeSockets();
                    return;
                }
                StringTokenizer requestLineTokenizer = new StringTokenizer(requestLine, " ");
                if (!requestLineTokenizer.hasMoreElements()) {
                    this.closeSockets();
                    return;
                }
                requestMethod = requestLineTokenizer.nextToken();
                if (!requestLineTokenizer.hasMoreElements()) {
                    this.closeSockets();
                    return;
                }
                requestUrl = requestLineTokenizer.nextToken();
                if (requestMethod.equals("POST")) {
                    internalRequestMethodCode = 2;
                } else if (requestMethod.equals("GET")) {
                    internalRequestMethodCode = 1;
                } else if (requestMethod.equals("HEAD")) {
                    internalRequestMethodCode = 1;
                } else {
                    this.closeSockets();
                    return;
                }
                int contentLength = 0;
                Vector v = this.readHeader();
                if (v == null) {
                    this.closeSockets();
                    return;
                }
                Enumeration headerLines = v.elements();
                boolean bl = bStatisticsHeaderFound = !headerLines.hasMoreElements();
                while (headerLines.hasMoreElements()) {
                    String currentHeaderLine = (String)headerLines.nextElement();
                    int fieldDelimiterPos = currentHeaderLine.indexOf(":");
                    if (fieldDelimiterPos < 0) {
                        this.closeSockets();
                        return;
                    }
                    String currentHeaderFieldName = currentHeaderLine.substring(0, fieldDelimiterPos);
                    String currentHeaderFieldValue = currentHeaderLine.substring(fieldDelimiterPos + 1).trim();
                    if (currentHeaderFieldName.equalsIgnoreCase("Content-Length")) {
                        try {
                            contentLength = Integer.parseInt(currentHeaderFieldValue);
                        }
                        catch (Exception e) {
                            this.closeSockets();
                            return;
                        }
                    }
                    if (currentHeaderFieldName.toLowerCase().startsWith("statistics".toLowerCase())) {
                        if (!ms_bLogAnonlibVersion && currentHeaderFieldName.equals("statistics-anonlib-version")) {
                            ms_bLogAnonlibVersion = true;
                        }
                        ISRuntimeStatistics.putClientVersion(currentHeaderFieldName, currentHeaderFieldValue);
                        bStatisticsHeaderFound = true;
                    }
                    if ((!currentHeaderFieldName.equalsIgnoreCase("Accept-Encoding") || internalRequestMethodCode != 1 && internalRequestMethodCode != 3) && (!currentHeaderFieldName.equalsIgnoreCase("Content-Encoding") || internalRequestMethodCode != 2) || currentHeaderFieldValue == null || currentHeaderFieldValue.indexOf("deflate") < 0) continue;
                    supportedEncodings = 1;
                }
                if (ms_bLogAnonlibVersion && internalRequestMethodCode == 1 && !bStatisticsHeaderFound) {
                    ISRuntimeStatistics.putClientVersion("statistics-anonlib-version", "unknown");
                }
                if (internalRequestMethodCode == 2 && contentLength >= 0) {
                    if (contentLength > Configuration.getInstance().getMaxPostContentLength()) {
                        throw new Exception("POST: Content is longer than allowed maximum POST content length.");
                    }
                    ByteArrayOutputStream postDataRead = new ByteArrayOutputStream(contentLength);
                    for (int currentPos = 0; currentPos < contentLength; ++currentPos) {
                        int byteRead = this.m_socket.getInputStream().read();
                        if (byteRead == -1) {
                            throw new Exception("POST: Content was shorter than specified in the header. Content length from header: " + Integer.toString(contentLength) + " Real content length: " + Integer.toString(currentPos));
                        }
                        postDataRead.write(byteRead);
                    }
                    postData = postDataRead.toByteArray();
                }
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.NET, "InfoServiceConnection (" + Integer.toString(this.m_connectionId) + ") - has an Error -", e);
                this.closeSockets();
                return;
            }
            try {
                response = this.m_serverImplementation.processCommand(internalRequestMethodCode, supportedEncodings, requestUrl, postData, this.m_socket.getInetAddress());
                if (response == null) {
                    LogHolder.log(5, LogType.NET, "InfoServiceConnection (" + Integer.toString(this.m_connectionId) + "): Response could not be generated: Request: " + requestMethod + " " + requestUrl);
                    response = new HttpResponseStructure(404);
                }
            }
            catch (Exception a_e) {
                LogHolder.log(0, LogType.NET, a_e);
                response = new HttpResponseStructure(500);
            }
            try {
                TimedOutputStream streamToClient = new TimedOutputStream(this.m_socket.getOutputStream(), 30000L);
                byte[] theResponse = response.getResponseData();
                int index = 0;
                int len = theResponse.length;
                int transferLen = 0;
                while (true) {
                    if (len > 5000) {
                        transferLen = 5000;
                    } else {
                        if (len <= 0) break;
                        transferLen = len;
                    }
                    try {
                        streamToClient.write(theResponse, index, transferLen);
                        streamToClient.flush();
                    }
                    catch (SocketException a_e) {
                        LogHolder.log(4, LogType.NET, "Client closed our response. " + a_e.getMessage());
                    }
                    catch (InterruptedIOException a_e) {
                        LogHolder.log(4, LogType.NET, "Response to client timed out. " + a_e.getMessage());
                    }
                    index += transferLen;
                    len -= transferLen;
                }
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.NET, "InfoServiceConnection (" + Integer.toString(this.m_connectionId) + "): Error while sending the response to the client.", e);
            }
        }
        catch (Throwable t) {
            LogHolder.log(2, LogType.NET, "Caught an unexpected connection error!", t);
        }
        this.closeSockets();
    }

    private void closeSockets() {
        this.m_serverImplementation = null;
        this.m_tmpByteArrayOut = null;
        try {
            this.m_socket.close();
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, "InfoServiceConnection (" + Integer.toString(this.m_connectionId) + "): Error while closing connection!", e);
        }
        this.m_socket = null;
    }

    private String readRequestLine() throws Exception {
        this.m_tmpByteArrayOut.reset();
        boolean requestLineReadingDone = false;
        while (!requestLineReadingDone) {
            int byteRead = this.read();
            if (byteRead == -1) {
                return null;
            }
            if (byteRead < 32 && byteRead != 13 || byteRead == 127) {
                return null;
            }
            if (byteRead == 13) {
                byteRead = this.read();
                if (byteRead != 10) {
                    return null;
                }
                requestLineReadingDone = true;
                continue;
            }
            this.m_tmpByteArrayOut.write(byteRead);
        }
        return this.m_tmpByteArrayOut.toString();
    }

    private void initReader(int limit) {
        this.m_byteLimit = limit;
    }

    private int read() throws Exception {
        if (this.m_byteLimit < 1) {
            throw new Exception("Cannot read more bytes, message size limit reached.");
        }
        int returnByte = -1;
        returnByte = this.m_socket.getInputStream().read();
        --this.m_byteLimit;
        return returnByte;
    }

    private Vector readHeader() throws Exception {
        this.m_tmpByteArrayOut.reset();
        Vector<String> allHeaderLines = new Vector<String>();
        boolean startOfHeader = true;
        boolean headerReadingDone = false;
        while (!headerReadingDone) {
            int byteRead = this.read();
            if (byteRead == 13) {
                byteRead = this.read();
                if (byteRead != 10) {
                    return null;
                }
                if (startOfHeader) {
                    headerReadingDone = true;
                } else {
                    byteRead = this.read();
                    if (byteRead != 9 && byteRead != 32) {
                        allHeaderLines.addElement(this.m_tmpByteArrayOut.toString());
                        this.m_tmpByteArrayOut.reset();
                        if (byteRead == 13) {
                            byteRead = this.read();
                            if (byteRead != 10) {
                                return null;
                            }
                            headerReadingDone = true;
                        }
                    }
                }
            }
            if (headerReadingDone) continue;
            if (startOfHeader) {
                startOfHeader = false;
            }
            if (byteRead == -1) {
                return null;
            }
            if (byteRead < 32 && byteRead != 9 || byteRead == 127) {
                return null;
            }
            this.m_tmpByteArrayOut.write(byteRead);
        }
        return allHeaderLines;
    }
}

