/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.MixCascade;
import anon.infoservice.PerformanceEntry;
import anon.infoservice.PerformanceInfo;
import anon.infoservice.update.AbstractDatabaseUpdater;
import anon.infoservice.update.PaymentInstanceUpdater;
import anon.infoservice.update.PerformanceInfoUpdater;
import anon.util.Updater;
import infoservice.MixInfoUpdater;
import infoservice.PassiveInfoServiceCascadeUpdater;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class PassiveInfoServiceMainUpdater
extends AbstractDatabaseUpdater {
    public static final String PERFORMANCE_LOG_FILE = "performancePassive_";
    PerformanceInfoUpdater m_performanceInfoUpdater = null;
    PassiveInfoServiceCascadeUpdater m_cascadeUpdater = null;
    MixInfoUpdater m_mixUpdater = null;
    PaymentInstanceUpdater piUpdater = null;
    private FileOutputStream m_stream = null;
    private int m_currentWeek;
    private final Calendar m_cal = Calendar.getInstance();

    public PassiveInfoServiceMainUpdater(long interval, boolean a_bFetchPerformanceData, Updater.ObservableInfo a_observableInfo) throws IOException {
        super(interval, a_observableInfo);
        this.m_cascadeUpdater = new PassiveInfoServiceCascadeUpdater(a_observableInfo);
        this.m_mixUpdater = new MixInfoUpdater(a_observableInfo);
        this.piUpdater = new PaymentInstanceUpdater(Long.MAX_VALUE, a_observableInfo);
        if (a_bFetchPerformanceData) {
            this.m_performanceInfoUpdater = new PerformanceInfoUpdater(Long.MAX_VALUE, a_observableInfo);
            this.m_cal.setTime(new Date(System.currentTimeMillis()));
            this.m_currentWeek = this.m_cal.get(3);
            if (this.m_cal.get(7) != 7) {
                this.readOldPerformanceData(this.m_currentWeek - 1);
            }
            this.readOldPerformanceData(this.m_currentWeek);
            try {
                this.m_stream = new FileOutputStream(PERFORMANCE_LOG_FILE + this.m_cal.get(1) + "_" + this.m_currentWeek + ".log", true);
            }
            catch (IOException ex) {
                LogHolder.log(4, LogType.NET, "Could not open performancePassive_.");
                throw ex;
            }
            Enumeration cascades = Database.getInstance(MixCascade.class).getEntrySnapshotAsEnumeration();
            while (cascades.hasMoreElements()) {
                this.getUpdatedEntry(((MixCascade)cascades.nextElement()).getId());
            }
        }
    }

    public PassiveInfoServiceMainUpdater(boolean a_bFetchPerformanceData, Updater.ObservableInfo a_observableInfo) throws IOException {
        this(Long.MAX_VALUE, a_bFetchPerformanceData, a_observableInfo);
    }

    @Override
    protected boolean doCleanup(Hashtable a_newEntries) {
        if (this.m_performanceInfoUpdater != null) {
            return super.doCleanup(a_newEntries);
        }
        return false;
    }

    @Override
    protected Hashtable getUpdatedEntries(Hashtable toUpdate) {
        if (this.m_performanceInfoUpdater != null) {
            this.m_performanceInfoUpdater.update();
        }
        this.piUpdater.update();
        this.m_cascadeUpdater.update();
        InfoServiceHolder.getInstance().updateExitAddresses();
        this.m_mixUpdater.updateAsync(null);
        Hashtable<String, PerformanceEntry> performanceEntries = new Hashtable<String, PerformanceEntry>();
        if (this.m_performanceInfoUpdater != null) {
            Enumeration enumCurrentPerEntries = Database.getInstance(PerformanceEntry.class).getEntrySnapshotAsEnumeration();
            Enumeration cascades = Database.getInstance(MixCascade.class).getEntrySnapshotAsEnumeration();
            while (cascades.hasMoreElements()) {
                String currentCascadeId = ((MixCascade)cascades.nextElement()).getId();
                performanceEntries.put(currentCascadeId, this.getUpdatedEntry(currentCascadeId));
            }
            while (enumCurrentPerEntries.hasMoreElements()) {
                PerformanceEntry curPerformanceEntry = (PerformanceEntry)enumCurrentPerEntries.nextElement();
                if (performanceEntries.containsKey(curPerformanceEntry.getId()) || System.currentTimeMillis() - curPerformanceEntry.getLastUpdate() >= 604800000L) continue;
                performanceEntries.put(curPerformanceEntry.getId(), this.getUpdatedEntry(curPerformanceEntry.getId()));
            }
        }
        return performanceEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceEntry getUpdatedEntry(String a_cascadeID) {
        PerformanceEntry dbPerformanceEntry = null;
        PerformanceEntry currentPerformanceEntry = PerformanceInfo.getLowestCommonBoundEntry(a_cascadeID);
        long timestamp = System.currentTimeMillis();
        Database database = Database.getInstance(PerformanceEntry.class);
        synchronized (database) {
            dbPerformanceEntry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(a_cascadeID);
            if (dbPerformanceEntry == null) {
                Database.getInstance(PerformanceEntry.class).update(currentPerformanceEntry);
            } else {
                currentPerformanceEntry = dbPerformanceEntry.update(currentPerformanceEntry);
            }
        }
        Vector attributeEntriesToUpdate = currentPerformanceEntry.updateHourlyPerformanceAttributeEntries(timestamp);
        for (int i = 0; i < attributeEntriesToUpdate.size(); ++i) {
            PerformanceEntry.StabilityAttributes stabilityAttributeEntry = currentPerformanceEntry.getStabilityAttributes();
            PerformanceEntry.PerformanceAttributeEntry attributeEntry = (PerformanceEntry.PerformanceAttributeEntry)attributeEntriesToUpdate.elementAt(i);
            attributeEntry.setErrors(stabilityAttributeEntry.getBoundErrors());
            attributeEntry.setUnknown(stabilityAttributeEntry.getBoundUnknown());
            attributeEntry.setResets(stabilityAttributeEntry.getBoundResets());
            attributeEntry.setSuccess(stabilityAttributeEntry.getValueSize() - stabilityAttributeEntry.getBoundErrors() - stabilityAttributeEntry.getBoundUnknown());
        }
        if (attributeEntriesToUpdate.size() > 0) {
            this.logPerftestData(timestamp, currentPerformanceEntry);
        }
        return currentPerformanceEntry;
    }

    @Override
    public Class getUpdatedClass() {
        return PerformanceEntry.class;
    }

    @Override
    protected Hashtable getEntrySerials() {
        return new Hashtable();
    }

    private void readOldPerformanceData(int week) {
        int year = this.m_cal.get(1);
        if (week == 0) {
            week = new GregorianCalendar(--year, 11, 31).get(3);
        }
        try {
            FileInputStream stream = new FileInputStream(PERFORMANCE_LOG_FILE + year + "_" + week + ".log");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            String line = null;
            long timestamp = -1L;
            int delay = -1;
            int speed = -1;
            int delayBest = -1;
            int speedBest = -1;
            int errors = -1;
            int unknown = -1;
            int resets = -1;
            String id = null;
            while ((line = reader.readLine()) != null) {
                PerformanceEntry.PerformanceAttributeEntry attrEntry;
                StringTokenizer tokenizer = new StringTokenizer(line);
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String currentToken = tokenizer.nextToken();
                    if (i == 0) {
                        timestamp = Long.parseLong(currentToken);
                    } else if (i == 1) {
                        id = currentToken;
                    } else if (i == 2) {
                        delay = Integer.parseInt(currentToken);
                    } else if (i == 3) {
                        delayBest = Integer.parseInt(currentToken);
                    } else if (i == 4) {
                        speed = Integer.parseInt(currentToken);
                    } else if (i == 5) {
                        speedBest = Integer.parseInt(currentToken);
                    } else if (i == 6) {
                        errors = Integer.parseInt(currentToken);
                    } else if (i == 7) {
                        unknown = Integer.parseInt(currentToken);
                    } else if (i == 8) {
                        resets = Integer.parseInt(currentToken);
                    } else {
                        LogHolder.log(4, LogType.MISC, "Too many performance log tokens: " + i);
                        break;
                    }
                    ++i;
                }
                if (i < 9) {
                    LogHolder.log(2, LogType.MISC, "No enough performance log tokens: " + i);
                }
                if (System.currentTimeMillis() - timestamp >= 604800000L) continue;
                PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(id);
                if (entry == null) {
                    entry = new PerformanceEntry(id, true);
                }
                PerformanceEntry.StabilityAttributes attrStability = new PerformanceEntry.StabilityAttributes(100, errors, unknown, resets);
                if (delay == 0) {
                    delay = -1;
                }
                if ((attrEntry = entry.importValue(1, timestamp, delay)) != null) {
                    attrEntry.setErrors(errors);
                    attrEntry.setUnknown(unknown);
                    attrEntry.setResets(resets);
                    attrEntry.setSuccess(100 - errors - unknown);
                }
                if (speed == Integer.MAX_VALUE) {
                    speed = -1;
                }
                if ((attrEntry = entry.importValue(0, timestamp, speed)) != null) {
                    attrEntry.setErrors(errors);
                    attrEntry.setUnknown(unknown);
                    attrEntry.setResets(resets);
                    attrEntry.setSuccess(100 - errors - unknown);
                }
                Database.getInstance(PerformanceEntry.class).update(entry);
            }
        }
        catch (IOException ex) {
            LogHolder.log(4, LogType.NET, "No previous performance data for this week found: " + ex.getMessage());
        }
        LogHolder.log(5, LogType.NET, "Added previous performance data for week" + week);
    }

    private void logPerftestData(long a_timestamp, PerformanceEntry a_entry) {
        try {
            this.m_cal.setTime(new Date(System.currentTimeMillis()));
            if (this.m_cal.get(3) != this.m_currentWeek) {
                this.m_currentWeek = this.m_cal.get(3);
                this.m_stream.close();
                this.m_stream = new FileOutputStream(PERFORMANCE_LOG_FILE + this.m_cal.get(1) + "_" + this.m_currentWeek + ".log", true);
            }
            PerformanceEntry.StabilityAttributes attributes = a_entry.getStabilityAttributes();
            this.m_stream.write((a_timestamp + "\t" + a_entry.getId() + "\t" + a_entry.getBound(1).getNotRecoveredBound() + "\t" + a_entry.getBestBound(1) + "\t" + a_entry.getBound(0).getNotRecoveredBound() + "\t" + a_entry.getBestBound(0) + "\t" + attributes.getBoundErrors() + "\t" + attributes.getBoundUnknown() + "\t" + attributes.getBoundResets() + "\n").getBytes());
            this.m_stream.flush();
        }
        catch (IOException ex) {
            LogHolder.log(2, LogType.NET, ex);
        }
    }
}

