/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.infoservice.StatusInfo;
import infoservice.Configuration;
import infoservice.StatusStatisticsEntry;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class StatusStatistics
implements Runnable {
    private static StatusStatistics ms_statusStatisticsInstance = null;
    private Hashtable m_statisticsDatabase = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatusStatistics getInstance() {
        Class<StatusStatistics> clazz = StatusStatistics.class;
        synchronized (StatusStatistics.class) {
            if (ms_statusStatisticsInstance == null) {
                ms_statusStatisticsInstance = new StatusStatistics();
                if (Configuration.getInstance().isStatusStatisticsEnabled()) {
                    Thread statusStatisticsThread = new Thread(ms_statusStatisticsInstance);
                    statusStatisticsThread.setDaemon(true);
                    statusStatisticsThread.start();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ms_statusStatisticsInstance;
        }
    }

    private StatusStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            long sleepTime = Configuration.getInstance().getStatusStatisticsInterval() - System.currentTimeMillis() % Configuration.getInstance().getStatusStatisticsInterval();
            try {
                Thread.sleep(sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long currentTime = System.currentTimeMillis();
            String timeStamp = Long.toString((currentTime / Configuration.getInstance().getStatusStatisticsInterval() - 1L) * Configuration.getInstance().getStatusStatisticsInterval());
            Vector entryList = new Vector();
            Hashtable hashtable = this.m_statisticsDatabase;
            synchronized (hashtable) {
                Enumeration statisticsDatabaseElements = this.m_statisticsDatabase.elements();
                while (statisticsDatabaseElements.hasMoreElements()) {
                    entryList.addElement(statisticsDatabaseElements.nextElement());
                }
                this.m_statisticsDatabase.clear();
            }
            Enumeration enumer = entryList.elements();
            while (true) {
                if (!enumer.hasMoreElements()) continue block7;
                StatusStatisticsEntry currentEntry = (StatusStatisticsEntry)enumer.nextElement();
                try {
                    FileWriter fw = new FileWriter(Configuration.getInstance().getStatusStatisticsLogDir() + currentEntry.getFileName(), true);
                    fw.write(timeStamp + ",");
                    fw.write(currentEntry.getLogString() + "\n");
                    fw.flush();
                    fw.close();
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "StatusStatistics: run: Could not write statistics for " + currentEntry.getId() + " to the file " + Configuration.getInstance().getStatusStatisticsLogDir() + currentEntry.getFileName() + ".\n" + e);
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(StatusInfo a_statusEntry) {
        if (Configuration.getInstance().isStatusStatisticsEnabled()) {
            Hashtable hashtable = this.m_statisticsDatabase;
            synchronized (hashtable) {
                StatusStatisticsEntry statisticsEntry = (StatusStatisticsEntry)this.m_statisticsDatabase.get(a_statusEntry.getId());
                if (statisticsEntry == null) {
                    this.m_statisticsDatabase.put(a_statusEntry.getId(), new StatusStatisticsEntry(a_statusEntry));
                } else {
                    statisticsEntry.updateStatistics(a_statusEntry);
                }
            }
        }
    }
}

