/*
 * Decompiled with CFR 0.152.
 */
package infoservice.tor;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ListenerInterface;
import infoservice.tor.TorDirectoryServerUrl;
import logging.LogHolder;
import logging.LogType;

public class TorDirectoryServer
extends AbstractDatabaseEntry {
    private TorDirectoryServerUrl m_url;
    private String m_id;
    private long m_creationTimeStamp = System.currentTimeMillis();
    private boolean m_bUserDefined;

    public TorDirectoryServer(TorDirectoryServerUrl a_url, long a_timeValid, boolean a_userDefined) {
        super(a_timeValid + System.currentTimeMillis());
        this.m_url = a_url;
        this.m_id = "http://" + a_url.getHost() + ":" + Integer.toString(a_url.getPort()) + a_url.getFileName();
        if (a_userDefined) {
            this.m_id = "(userdefined) " + this.m_id;
        }
        this.m_bUserDefined = a_userDefined;
    }

    public byte[] downloadCompressedTorNodesInformation() {
        LogHolder.log(6, LogType.NET, "Try to get tor nodes list from http://" + this.m_url.getHost() + ":" + Integer.toString(this.m_url.getPort()) + this.m_url.getFileName());
        byte[] torNodesList = null;
        try {
            HTTPConnection conn = HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_url.getHost(), this.m_url.getPort()));
            conn.removeModule(Class.forName("HTTPClient.ContentEncodingModule"));
            HTTPResponse resp = conn.Get(this.m_url.getFileName());
            LogHolder.log(6, LogType.NET, "Try to get tor nodes list from http://" + this.m_url.getHost() + ":" + Integer.toString(this.m_url.getPort()) + this.m_url.getFileName() + "conn.Get() called");
            torNodesList = resp.getData();
            LogHolder.log(6, LogType.NET, "Got the list from http://" + this.m_url.getHost() + ":" + Integer.toString(this.m_url.getPort()) + this.m_url.getFileName());
        }
        catch (Throwable e) {
            LogHolder.log(3, LogType.NET, "TorDirectoryServer: downloadTorNodesInformation: Error while getting tor nodes list (" + e.toString() + ").");
            torNodesList = null;
        }
        return torNodesList;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public long getVersionNumber() {
        return this.m_creationTimeStamp;
    }

    @Override
    public long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    @Override
    public boolean isUserDefined() {
        return this.m_bUserDefined;
    }
}

