/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.AnonChannel;
import anon.client.AbstractAnonUDPChannel;
import anon.client.UDPPacketStreamDesynchronisationException;
import anon.client.UDPPacketToLargeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AnonUDPChannel
extends AbstractAnonUDPChannel {
    private static final int UDP_PROTOCOL_HEADER_SIZE = 2;
    private AnonChannel m_channelUnderlyingChannel = null;
    private boolean m_bConnectSent = false;
    private OutputStream m_Out;
    private InputStream m_In;
    private int m_iRemainingLenUDPPayload = -1;

    protected AnonUDPChannel(AnonChannel a_channelUnderlyingChannel) {
        this.m_channelUnderlyingChannel = a_channelUnderlyingChannel;
        this.m_Out = this.m_channelUnderlyingChannel.getOutputStream();
        this.m_In = this.m_channelUnderlyingChannel.getInputStream();
    }

    private void getConnectMsg(byte[] req) {
        int lenHostname = this.m_strDstHost.length();
        req[0] = 1;
        req[1] = 4;
        req[2] = 3;
        req[3] = (byte)lenHostname;
        byte[] bar_hostname = this.m_strDstHost.getBytes();
        System.arraycopy(bar_hostname, 0, req, 4, lenHostname);
        req[4 + lenHostname] = (byte)(this.m_iDstPort >> 8 & 0xFF);
        req[5 + lenHostname] = (byte)(this.m_iDstPort & 0xFF);
        req[6 + lenHostname] = (byte)(this.m_iSrcPort >> 8 & 0xFF);
        req[7 + lenHostname] = (byte)(this.m_iSrcPort & 0xFF);
    }

    private int getConnectMsgSize() {
        return this.m_strDstHost.length() + 8;
    }

    public void setSentAutoFlushDelay(int msAutoFlushDelay) {
    }

    public void writePacket(byte[] payload, int offset, int len) throws IOException {
        int bytes_written;
        if (!this.m_bConnectSent) {
            int connectMsgSize = this.getConnectMsgSize();
            byte[] msg = new byte[connectMsgSize + 2 + len];
            this.getConnectMsg(msg);
            msg[connectMsgSize] = (byte)(len >> 8 & 0xFF);
            msg[connectMsgSize + 1] = (byte)(len & 0xFF);
            System.arraycopy(payload, offset, msg, connectMsgSize + 2, len);
            payload = msg;
            offset = 0;
            len += connectMsgSize + 2;
            this.m_bConnectSent = true;
        } else {
            byte[] firstPacket = new byte[this.m_channelUnderlyingChannel.getOutputBlockSize()];
            firstPacket[0] = (byte)(len >> 8 & 0xFF);
            firstPacket[1] = (byte)(len & 0xFF);
            bytes_written = Math.min(firstPacket.length - 2, len);
            System.arraycopy(payload, offset, firstPacket, 2, bytes_written);
            this.m_Out.write(firstPacket, 0, bytes_written + 2);
            len -= bytes_written;
            offset += bytes_written;
        }
        while (len > 0) {
            bytes_written = Math.min(this.m_channelUnderlyingChannel.getOutputBlockSize(), len);
            this.m_Out.write(payload, offset, bytes_written);
            offset += bytes_written;
            len -= bytes_written;
        }
    }

    public int readPacket(byte[] payload, int off, int len) throws IOException, UDPPacketStreamDesynchronisationException, UDPPacketToLargeException {
        int ret = -1;
        if (this.m_iRemainingLenUDPPayload <= 0) {
            this.m_iRemainingLenUDPPayload = this.m_In.read();
            if (this.m_iRemainingLenUDPPayload < 0) {
                return -1;
            }
            this.m_iRemainingLenUDPPayload <<= 8;
            ret = this.m_In.read();
            if (ret < 0) {
                return -1;
            }
            this.m_iRemainingLenUDPPayload |= ret & 0xFF;
            this.m_iRemainingLenUDPPayload &= 0xFFFF;
        } else {
            throw new UDPPacketStreamDesynchronisationException();
        }
        if (this.m_iRemainingLenUDPPayload > len) {
            throw new UDPPacketToLargeException();
        }
        len = this.m_iRemainingLenUDPPayload;
        while (this.m_iRemainingLenUDPPayload > 0) {
            ret = this.m_In.read(payload, off, this.m_iRemainingLenUDPPayload);
            if (ret >= 0) {
                this.m_iRemainingLenUDPPayload -= ret;
                off += ret;
                continue;
            }
            return ret;
        }
        return len;
    }

    public int getOutputBlockSize() {
        return this.m_channelUnderlyingChannel.getOutputBlockSize() - 2;
    }

    public void close() {
        this.m_channelUnderlyingChannel.close();
    }

    public boolean isClosed() {
        return this.m_channelUnderlyingChannel.isClosed();
    }
}

