/*
 * Decompiled with CFR 0.152.
 */
package anon.terms.template;

import anon.infoservice.OperatorAddress;
import anon.infoservice.ServiceOperator;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Preamble {
    public static String XML_ELEMENT_NAME = "Preamble";
    public static String XML_ELEMENT_LEADING_TEXT = "LeadingText";
    public static String XML_ELEMENT_TRAILING_TEXT = "TrailingText";
    private String leadingText = null;
    private ServiceOperator operator = null;
    private OperatorAddress operatorAddress = null;
    private String trailingText = null;

    public Preamble() {
    }

    public Preamble(Node rootNode) throws XMLParseException {
        Element preambleRoot = null;
        if (rootNode.getNodeType() == 9) {
            preambleRoot = ((Document)rootNode).getDocumentElement();
        } else if (rootNode.getNodeType() == 1) {
            preambleRoot = (Element)rootNode;
        } else {
            throw new XMLParseException("Invalid node type");
        }
        Element leadingTextElement = (Element)XMLUtil.getFirstChildByName(preambleRoot, XML_ELEMENT_LEADING_TEXT);
        Element trailingTextElement = (Element)XMLUtil.getFirstChildByName(preambleRoot, XML_ELEMENT_TRAILING_TEXT);
        this.leadingText = leadingTextElement != null ? XMLUtil.parseValue((Node)leadingTextElement, (String)null) : null;
        this.trailingText = trailingTextElement != null ? XMLUtil.parseValue((Node)trailingTextElement, (String)null) : null;
    }

    public String getLeadingText() {
        return this.leadingText;
    }

    public void setLeadingText(String leadingText) {
        this.leadingText = leadingText;
    }

    public ServiceOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ServiceOperator operator) {
        this.operator = operator;
    }

    public OperatorAddress getOperatorAddress() {
        return this.operatorAddress;
    }

    public void setOperatorAddress(OperatorAddress operatorAddress) {
        this.operatorAddress = operatorAddress;
    }

    public String getTrailingText() {
        return this.trailingText;
    }

    public void setTrailingText(String trailingText) {
        this.trailingText = trailingText;
    }

    public Element toXmlElement(Document ownerDoc) {
        Element preambleRoot = ownerDoc.createElement(XML_ELEMENT_NAME);
        Element leadingTextElement = ownerDoc.createElement(XML_ELEMENT_LEADING_TEXT);
        Element trailingTextElement = ownerDoc.createElement(XML_ELEMENT_TRAILING_TEXT);
        Element operatorElement = this.operator != null ? this.operator.toXMLElement(ownerDoc, this.operatorAddress, false) : ownerDoc.createElement("Operator");
        XMLUtil.setValue((Node)leadingTextElement, this.leadingText != null ? this.leadingText : "");
        XMLUtil.setValue((Node)trailingTextElement, this.trailingText != null ? this.trailingText : "");
        preambleRoot.appendChild(leadingTextElement);
        preambleRoot.appendChild(operatorElement);
        preambleRoot.appendChild(trailingTextElement);
        return preambleRoot;
    }
}

