/*
 * Decompiled with CFR 0.152.
 */
package jap;

import jap.ISplashResponse;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public final class JAPSplash
extends Window
implements ISplashResponse {
    private static final long serialVersionUID = 1L;
    private static final String IMGPATHHICOLOR = "images/";
    private static final String IMGPATHLOWCOLOR = "images/lowcolor/";
    private static final String SPLASH_FILE = "splash.jpg";
    private static final String BUSY_FILE = "busy.gif";
    private static final int SPLASH_WIDTH = 501;
    private static final int SPLASH_HEIGHT = 330;
    private static final int SPLASH_FILESIZE = 150000;
    private static final int BUSY_FILESIZE = 7000;
    private static final int VERSION_OFFSET_X = 10;
    private static final int VERSION_OFFSET_Y = 15;
    private static final int BUSY_POSITION_X = 15;
    private static final int BUSY_POSITION_Y = 312;
    private static final int MESSAGE_POSITION_X = 17;
    private static final int MESSAGE_POSITION_Y = 302;
    private Image m_imgSplash;
    private Image m_imgBusy;
    private Image m_imgOffScreen = null;
    private Font m_fntFont;
    private String m_strLoading;
    private String m_currentText;
    private String m_strVersion;
    private int m_iXVersion;
    private int m_iYVersion;

    public JAPSplash(Frame a_frmParent) {
        this(a_frmParent, null);
    }

    public JAPSplash(Frame frmParent, String a_message) {
        super(frmParent);
        this.setLayout(null);
        this.m_iYVersion = 100;
        this.m_iXVersion = 100;
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        MediaTracker imageTracker = new MediaTracker(this);
        this.loadImages(imageTracker);
        if (a_message == null || a_message.trim().length() == 0) {
            this.setText("Busy");
        } else {
            this.setText(a_message);
        }
        this.m_strVersion = "Version: 00.20.010";
        this.m_fntFont = new Font("Sans", 0, 9);
        FontMetrics fontmetrics = defaultToolkit.getFontMetrics(this.m_fntFont);
        this.m_iXVersion = 491 - fontmetrics.stringWidth(this.m_strVersion);
        this.m_iYVersion = 315;
        this.setSize(501, 330);
        try {
            imageTracker.waitForAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.toFront();
    }

    private Image loadImage(String pathToFile, int filesize, MediaTracker imageTracker) {
        InputStream in = null;
        Class<?> JapClass = null;
        try {
            JapClass = Class.forName("JAP");
        }
        catch (Exception e) {
            // empty catch block
        }
        in = JapClass.getResourceAsStream(pathToFile);
        if (in == null) {
            try {
                in = new FileInputStream(pathToFile);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        Image imageResult = null;
        if (in != null) {
            Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
            byte[] buff = new byte[filesize];
            int len = 0;
            int aktIndex = 0;
            try {
                while ((len = in.read(buff, aktIndex, buff.length - aktIndex)) > 0) {
                    aktIndex += len;
                }
                imageResult = defaultToolkit.createImage(buff, 0, aktIndex);
                imageTracker.addImage(this.m_imgSplash, 1);
                imageTracker.checkID(1, true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return imageResult;
    }

    private boolean isHighColor() {
        ColorModel colorModel = null;
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        try {
            colorModel = defaultToolkit.getColorModel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (colorModel == null) {
            return false;
        }
        return colorModel.getPixelSize() > 16;
    }

    private void loadImages(MediaTracker imageTracker) {
        if (this.isHighColor()) {
            this.m_imgSplash = this.loadImage("images/splash.jpg", 150000, imageTracker);
            this.m_imgBusy = this.loadImage("images/busy.gif", 7000, imageTracker);
        } else {
            this.m_imgSplash = this.loadImage("images/lowcolor/splash.jpg", 150000, imageTracker);
            this.m_imgBusy = this.loadImage("images/lowcolor/busy.gif", 7000, imageTracker);
        }
    }

    public void setText(String a_text) {
        if (a_text != null && a_text.trim().length() > 0) {
            this.m_currentText = a_text;
            this.m_strLoading = a_text + "...";
        }
    }

    public String getText() {
        return this.m_currentText;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.m_imgOffScreen == null) {
            this.m_imgOffScreen = this.createImage(501, 330);
        }
        Graphics offscreenGraphics = this.m_imgOffScreen.getGraphics();
        if (this.m_imgSplash != null) {
            offscreenGraphics.drawImage(this.m_imgSplash, 0, 0, this);
        }
        if (this.m_imgBusy != null) {
            offscreenGraphics.drawImage(this.m_imgBusy, 15, 312, this);
        }
        offscreenGraphics.setColor(Color.gray);
        offscreenGraphics.drawRect(0, 0, 500, 329);
        offscreenGraphics.setFont(this.m_fntFont);
        offscreenGraphics.setColor(Color.black);
        offscreenGraphics.drawString(this.m_strLoading, 17, 302);
        offscreenGraphics.drawString(this.m_strVersion, this.m_iXVersion, this.m_iYVersion);
        g.drawImage(this.m_imgOffScreen, 0, 0, this);
    }

    public void centerOnScreen() {
        JAPSplash.centerOnScreen(this);
    }

    private static void centerOnScreen(Window a_window) {
        Rectangle screenBounds;
        Dimension ownSize = a_window.getSize();
        try {
            Object graphicsEnvironment = Class.forName("java.awt.GraphicsEnvironment").getMethod("getLocalGraphicsEnvironment", null).invoke(null, null);
            Object graphicsDevice = graphicsEnvironment.getClass().getMethod("getDefaultScreenDevice", null).invoke(graphicsEnvironment, null);
            Object graphicsConfiguration = graphicsDevice.getClass().getMethod("getDefaultConfiguration", null).invoke(graphicsDevice, null);
            screenBounds = (Rectangle)graphicsConfiguration.getClass().getMethod("getBounds", null).invoke(graphicsConfiguration, null);
        }
        catch (Exception a_e) {
            screenBounds = new Rectangle(new Point(0, 0), a_window.getToolkit().getScreenSize());
        }
        a_window.setLocation(screenBounds.x + (screenBounds.width - ownSize.width) / 2, screenBounds.y + (screenBounds.height - ownSize.height) / 2);
    }
}

