/*
 * Decompiled with CFR 0.152.
 */
package logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import logging.AbstractLog;
import logging.DummyLog;
import logging.ILog;

public final class LogHolder {
    public static final int CALLING_METHOD_IGNORE = 0;
    public static final int CALLING_METHOD_ADD = 1;
    public static final int CALLING_METHOD_ONLY = 2;
    public static final int DETAIL_LEVEL_LOWEST = 0;
    public static final int DETAIL_LEVEL_LOWER = 1;
    public static final int DETAIL_LEVEL_HIGH = 2;
    public static final int DETAIL_LEVEL_HIGHEST = 3;
    private static final String[] DETAIL_LEVEL_NAMES = new String[]{"_detailLowest", "_detailLower", "_detailHigh", "_detailHighest"};
    private static final String TRACED_LOG_MESSAGE = "[Traced log Message]:";
    private static final String LOGGED_THROWABLE = " Logged Throwable: ";
    private static final int LINE_LENGTH_HIGH_DETAIL = 40;
    private static final int LINE_LENGTH_HIGHEST_DETAIL = 70;
    private static LogHolder ms_logHolderInstance;
    private static int m_messageDetailLevel;
    private static ILog ms_logInstance;
    static /* synthetic */ Class class$logging$LogHolder;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Exception;

    private LogHolder() {
        ms_logInstance = new DummyLog();
    }

    public void finalize() throws Throwable {
        if (this.equals(ms_logHolderInstance)) {
            ms_logHolderInstance = null;
        }
        super.finalize();
    }

    public static int getDetailLevelCount() {
        return DETAIL_LEVEL_NAMES.length;
    }

    public static String getDetailLevelName(int a_detail) {
        if (a_detail < 0 || a_detail >= DETAIL_LEVEL_NAMES.length) {
            return null;
        }
        return DETAIL_LEVEL_NAMES[a_detail];
    }

    public static boolean setDetailLevel(int a_messageDetailLevel) {
        if (a_messageDetailLevel < 0) {
            return false;
        }
        if (a_messageDetailLevel > 3) {
            return false;
        }
        m_messageDetailLevel = a_messageDetailLevel;
        return true;
    }

    public static int getDetailLevel() {
        return m_messageDetailLevel;
    }

    public static synchronized void log(int a_logLevel, int a_logType, Throwable a_throwable) {
        LogHolder.log(a_logLevel, a_logType, null, a_throwable);
    }

    public static synchronized void log(int a_logLevel, int a_logType, Throwable a_throwable, int a_bAddCallingClass) {
        LogHolder.log(a_logLevel, a_logType, null, a_throwable, a_bAddCallingClass);
    }

    public static synchronized void log(int a_logLevel, int a_logType, String a_message, Throwable a_throwable) {
        LogHolder.log(a_logLevel, a_logType, a_message, a_throwable, 0);
    }

    public static synchronized void log(int a_logLevel, int a_logType, String a_message, Throwable a_throwable, int a_bAddCallingClass) {
        if (LogHolder.isLogged(a_logLevel, a_logType)) {
            String message = "";
            if (a_message != null && a_message.length() > 0) {
                message = a_message;
            }
            if (m_messageDetailLevel <= 0) {
                if (a_throwable != null && message.trim().length() == 0 && (message = a_throwable.getMessage()) == null) {
                    message = a_throwable.toString();
                }
                LogHolder.getLogInstance().log(a_logLevel, a_logType, message);
            } else if (m_messageDetailLevel > 0 && m_messageDetailLevel < 2) {
                if (a_throwable != null) {
                    if (message.trim().length() == 0) {
                        message = a_throwable.getMessage();
                        if (message == null) {
                            message = a_throwable.toString();
                        }
                    } else if (a_throwable.getMessage() != null) {
                        message = message + "\n Logged Throwable: " + a_throwable.getMessage();
                    }
                }
                LogHolder.getLogInstance().log(a_logLevel, a_logType, message);
            } else if (m_messageDetailLevel == 2) {
                if (a_throwable != null) {
                    message = message.trim().length() == 0 ? a_throwable.toString() : message + "\n Logged Throwable: " + a_throwable.toString();
                }
                if (a_bAddCallingClass == 1) {
                    ms_logInstance.log(a_logLevel, a_logType, LogHolder.normaliseString(LogHolder.getCallingClassFile(false) + ": ", 40) + TRACED_LOG_MESSAGE);
                }
                ms_logInstance.log(a_logLevel, a_logType, LogHolder.normaliseString(LogHolder.getCallingClassFile(a_bAddCallingClass != 0) + ": ", 40) + message);
            } else if (m_messageDetailLevel >= 3) {
                if (a_throwable != null) {
                    message = message.trim().length() == 0 ? LogHolder.getStackTrace(a_throwable) : message + "\n Logged Throwable: " + LogHolder.getStackTrace(a_throwable);
                }
                if (a_bAddCallingClass == 1) {
                    ms_logInstance.log(a_logLevel, a_logType, LogHolder.normaliseString(LogHolder.getCallingMethod(false) + ": ", 70) + TRACED_LOG_MESSAGE);
                }
                ms_logInstance.log(a_logLevel, a_logType, LogHolder.normaliseString(LogHolder.getCallingMethod(a_bAddCallingClass != 0) + ": ", 70) + message);
            }
        }
    }

    public static void log(int logLevel, int logType, String message, int a_bAddCallingClass) {
        LogHolder.log(logLevel, logType, message, null, a_bAddCallingClass);
    }

    public static void log(int logLevel, int logType, String message) {
        LogHolder.log(logLevel, logType, message, 0);
    }

    public static synchronized void setLogInstance(ILog logInstance) {
        ms_logInstance = logInstance;
        if (ms_logInstance == null) {
            ms_logInstance = new DummyLog();
        }
    }

    private static ILog getLogInstance() {
        return ms_logInstance;
    }

    public static synchronized boolean isLogged(int a_logLevel, int a_logType) {
        if (ms_logInstance instanceof AbstractLog) {
            return ((AbstractLog)ms_logInstance).isLogged(a_logLevel, a_logType);
        }
        return AbstractLog.isLogged(ms_logInstance, a_logLevel, a_logType);
    }

    private static String getCallingClassFile(boolean a_bSkipOwnClass) {
        String strClassFile = LogHolder.getCallingMethod(a_bSkipOwnClass);
        strClassFile = strClassFile.substring(strClassFile.indexOf(40), strClassFile.indexOf(41) + 1);
        return strClassFile;
    }

    public static String getCallingMethod(boolean a_bSkipOwnClass) {
        String strCurrentMethod = "";
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        String strOwnClass = "   ";
        new Exception().printStackTrace(pwriter);
        StringTokenizer tokenizer = new StringTokenizer(swriter.toString());
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            int ind;
            tokenizer.nextToken();
            strCurrentMethod = tokenizer.nextToken().replace('/', '.');
            if (strCurrentMethod.indexOf(40) > 0) {
                while (strCurrentMethod.indexOf(41) < 0) {
                    strCurrentMethod = strCurrentMethod + tokenizer.nextToken();
                }
            }
            if (strCurrentMethod.startsWith((class$logging$LogHolder == null ? LogHolder.class$("logging.LogHolder") : class$logging$LogHolder).getName()) || strCurrentMethod.startsWith(strOwnClass) || strCurrentMethod.startsWith((class$java$lang$Throwable == null ? LogHolder.class$("java.lang.Throwable") : class$java$lang$Throwable).getName()) || strCurrentMethod.startsWith((class$java$lang$Exception == null ? LogHolder.class$("java.lang.Exception") : class$java$lang$Exception).getName())) continue;
            if (!a_bSkipOwnClass || strOwnClass.trim().length() != 0) break;
            strOwnClass = strCurrentMethod;
            int index = strCurrentMethod.indexOf(40);
            if (index > 0) {
                strOwnClass = strCurrentMethod.substring(0, index);
            }
            if ((ind = strOwnClass.lastIndexOf(46)) >= 0) {
                strOwnClass = strOwnClass.substring(0, ind);
            }
            if (strOwnClass.indexOf("$") <= 0) continue;
            strOwnClass = strOwnClass.substring(0, strOwnClass.indexOf("$"));
        }
        return strCurrentMethod;
    }

    private static String normaliseString(String a_string, int a_normLength) {
        if (a_string.length() < a_normLength) {
            char[] space = new char[a_normLength - a_string.length()];
            for (int i = 0; i < space.length; ++i) {
                space[i] = 32;
            }
            a_string = a_string + new String(space);
        }
        return a_string;
    }

    private static String getStackTrace(Throwable a_t) {
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        a_t.printStackTrace(writer);
        return strWriter.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_messageDetailLevel = 3;
        ms_logInstance = new DummyLog();
    }
}

