/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import org.apache.oro.text.regex.OpCode;
import org.apache.oro.text.regex.Perl5Pattern;

public final class Perl5Debug {
    private Perl5Debug() {
    }

    public static String printProgram(Perl5Pattern regexp) {
        int operator = 27;
        char[] prog = regexp._program;
        int offset = 1;
        StringBuffer buffer = new StringBuffer();
        while (operator != 0) {
            operator = prog[offset];
            buffer.append(offset);
            Perl5Debug._printOperator(prog, offset, buffer);
            int next = OpCode._getNext(prog, offset);
            offset += OpCode._operandLength[operator];
            buffer.append("(" + next + ")");
            offset += 2;
            if (operator == 9) {
                offset += 16;
            } else if (operator == 35 || operator == 36) {
                while (prog[offset] != '\u0000') {
                    if (prog[offset] == '%') {
                        offset += 3;
                        continue;
                    }
                    offset += 2;
                }
                ++offset;
            } else if (operator == 14) {
                ++offset;
                buffer.append(" <");
                while (prog[offset] != '\uffff') {
                    buffer.append(prog[offset]);
                    ++offset;
                }
                buffer.append(">");
                ++offset;
            }
            buffer.append('\n');
        }
        if (regexp._startString != null) {
            buffer.append("start `" + new String(regexp._startString) + "' ");
        }
        if (regexp._startClassOffset != -1) {
            buffer.append("stclass `");
            Perl5Debug._printOperator(prog, regexp._startClassOffset, buffer);
            buffer.append("' ");
        }
        if ((regexp._anchor & 3) != 0) {
            buffer.append("anchored ");
        }
        if ((regexp._anchor & 4) != 0) {
            buffer.append("plus ");
        }
        if ((regexp._anchor & 8) != 0) {
            buffer.append("implicit ");
        }
        if (regexp._mustString != null) {
            buffer.append("must have \"" + new String(regexp._mustString) + "\" back " + regexp._back + " ");
        }
        buffer.append("minlen " + regexp._minLength + '\n');
        return buffer.toString();
    }

    static void _printOperator(char[] program, int offset, StringBuffer buffer) {
        String str = null;
        buffer.append(":");
        switch (program[offset]) {
            case '\u0001': {
                str = "BOL";
                break;
            }
            case '\u0002': {
                str = "MBOL";
                break;
            }
            case '\u0003': {
                str = "SBOL";
                break;
            }
            case '\u0004': {
                str = "EOL";
                break;
            }
            case '\u0005': {
                str = "MEOL";
                break;
            }
            case '\u0007': {
                str = "ANY";
                break;
            }
            case '\b': {
                str = "SANY";
                break;
            }
            case '\t': {
                str = "ANYOF";
                break;
            }
            case '#': {
                str = "ANYOFUN";
                break;
            }
            case '$': {
                str = "NANYOFUN";
                break;
            }
            case '\f': {
                str = "BRANCH";
                break;
            }
            case '\u000e': {
                str = "EXACTLY";
                break;
            }
            case '\u000f': {
                str = "NOTHING";
                break;
            }
            case '\r': {
                str = "BACK";
                break;
            }
            case '\u0000': {
                str = "END";
                break;
            }
            case '\u0012': {
                str = "ALNUM";
                break;
            }
            case '\u0013': {
                str = "NALNUM";
                break;
            }
            case '\u0014': {
                str = "BOUND";
                break;
            }
            case '\u0015': {
                str = "NBOUND";
                break;
            }
            case '\u0016': {
                str = "SPACE";
                break;
            }
            case '\u0017': {
                str = "NSPACE";
                break;
            }
            case '\u0018': {
                str = "DIGIT";
                break;
            }
            case '\u0019': {
                str = "NDIGIT";
                break;
            }
            case '&': {
                str = "ALPHA";
                break;
            }
            case '\'': {
                str = "BLANK";
                break;
            }
            case '(': {
                str = "CNTRL";
                break;
            }
            case ')': {
                str = "GRAPH";
                break;
            }
            case '*': {
                str = "LOWER";
                break;
            }
            case '+': {
                str = "PRINT";
                break;
            }
            case ',': {
                str = "PUNCT";
                break;
            }
            case '-': {
                str = "UPPER";
                break;
            }
            case '.': {
                str = "XDIGIT";
                break;
            }
            case '2': {
                str = "ALNUMC";
                break;
            }
            case '3': {
                str = "ASCII";
                break;
            }
            case '\n': {
                buffer.append("CURLY {");
                buffer.append((int)OpCode._getArg1(program, offset));
                buffer.append(',');
                buffer.append((int)OpCode._getArg2(program, offset));
                buffer.append('}');
                break;
            }
            case '\u000b': {
                buffer.append("CURLYX {");
                buffer.append((int)OpCode._getArg1(program, offset));
                buffer.append(',');
                buffer.append((int)OpCode._getArg2(program, offset));
                buffer.append('}');
                break;
            }
            case '\u001a': {
                buffer.append("REF");
                buffer.append((int)OpCode._getArg1(program, offset));
                break;
            }
            case '\u001b': {
                buffer.append("OPEN");
                buffer.append((int)OpCode._getArg1(program, offset));
                break;
            }
            case '\u001c': {
                buffer.append("CLOSE");
                buffer.append((int)OpCode._getArg1(program, offset));
                break;
            }
            case '\u0010': {
                str = "STAR";
                break;
            }
            case '\u0011': {
                str = "PLUS";
                break;
            }
            case '\u001d': {
                str = "MINMOD";
                break;
            }
            case '\u001e': {
                str = "GBOL";
                break;
            }
            case ' ': {
                str = "UNLESSM";
                break;
            }
            case '\u001f': {
                str = "IFMATCH";
                break;
            }
            case '!': {
                str = "SUCCEED";
                break;
            }
            case '\"': {
                str = "WHILEM";
                break;
            }
            default: {
                buffer.append("Operator is unrecognized.  Faulty expression code!");
            }
        }
        if (str != null) {
            buffer.append(str);
        }
    }
}

