/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Vector;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Substitution;

public final class Util {
    public static final int SUBSTITUTE_ALL = -1;
    public static final int SPLIT_ALL = 0;

    private Util() {
    }

    public static void split(Vector results, PatternMatcher matcher, Pattern pattern, String input, int limit) {
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int beginOffset = 0;
        while (--limit != 0 && matcher.contains(pinput, pattern)) {
            MatchResult currentResult = matcher.getMatch();
            results.addElement(input.substring(beginOffset, currentResult.beginOffset(0)));
            beginOffset = currentResult.endOffset(0);
        }
        results.addElement(input.substring(beginOffset, input.length()));
    }

    public static void split(Vector results, PatternMatcher matcher, Pattern pattern, String input) {
        Util.split(results, matcher, pattern, input, 0);
    }

    public static Vector split(PatternMatcher matcher, Pattern pattern, String input, int limit) {
        Vector results = new Vector(20);
        Util.split(results, matcher, pattern, input, limit);
        return results;
    }

    public static Vector split(PatternMatcher matcher, Pattern pattern, String input) {
        return Util.split(matcher, pattern, input, 0);
    }

    public static String substitute(PatternMatcher matcher, Pattern pattern, Substitution sub, String input, int numSubs) {
        PatternMatcherInput pinput;
        StringBuffer buffer = new StringBuffer(input.length());
        if (Util.substitute(buffer, matcher, pattern, sub, pinput = new PatternMatcherInput(input), numSubs) != 0) {
            return buffer.toString();
        }
        return input;
    }

    public static String substitute(PatternMatcher matcher, Pattern pattern, Substitution sub, String input) {
        return Util.substitute(matcher, pattern, sub, input, 1);
    }

    public static int substitute(StringBuffer result, PatternMatcher matcher, Pattern pattern, Substitution sub, String input, int numSubs) {
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        return Util.substitute(result, matcher, pattern, sub, pinput, numSubs);
    }

    public static int substitute(StringBuffer result, PatternMatcher matcher, Pattern pattern, Substitution sub, PatternMatcherInput input, int numSubs) {
        int subCount = 0;
        int beginOffset = input.getBeginOffset();
        char[] inputBuffer = input.getBuffer();
        while (numSubs != 0 && matcher.contains(input, pattern)) {
            --numSubs;
            result.append(inputBuffer, beginOffset, input.getMatchBeginOffset() - beginOffset);
            sub.appendSubstitution(result, matcher.getMatch(), ++subCount, input, matcher, pattern);
            beginOffset = input.getMatchEndOffset();
        }
        result.append(inputBuffer, beginOffset, input.length() - beginOffset);
        return subCount;
    }
}

