/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.ISendCallbackHandler;
import anon.client.MixPacket;
import anon.client.crypto.IMixCipher;
import anon.client.crypto.SymCipher;
import java.util.Vector;

public class FirstMixCipher
implements IMixCipher {
    private boolean m_firstEncryptionPacket = true;
    private SymCipher m_mixCipher;
    private SymCipher m_channelSymCipher;

    public FirstMixCipher(SymCipher a_mixCipher, SymCipher a_channelSymCipher) {
        this.m_mixCipher = a_mixCipher;
        this.m_channelSymCipher = a_channelSymCipher;
    }

    public byte[] encrypt(byte[] a_packet, int a_virtualPacketLength, Vector a_sendCallbackHandlers) {
        int alreadyEncryptedBytes = 0;
        int realPacketLength = a_packet.length;
        byte[] packet = null;
        byte[] encryptedPacket = null;
        if (this.m_firstEncryptionPacket) {
            packet = a_virtualPacketLength > (realPacketLength += this.m_channelSymCipher.getKeys().length) ? new byte[a_virtualPacketLength] : new byte[realPacketLength];
            System.arraycopy(this.m_channelSymCipher.getKeys(), 0, packet, 0, this.m_channelSymCipher.getKeys().length);
            System.arraycopy(a_packet, 0, packet, this.m_channelSymCipher.getKeys().length, a_packet.length);
            encryptedPacket = new byte[packet.length];
            System.arraycopy(packet, 0, encryptedPacket, 0, this.m_channelSymCipher.getKeys().length);
            alreadyEncryptedBytes = this.m_channelSymCipher.getKeys().length;
            a_sendCallbackHandlers.addElement(new MixEncryptionHandler(this.m_mixCipher, alreadyEncryptedBytes));
            this.m_firstEncryptionPacket = false;
        } else {
            packet = a_virtualPacketLength > realPacketLength ? new byte[a_virtualPacketLength] : new byte[realPacketLength];
            System.arraycopy(a_packet, 0, packet, 0, a_packet.length);
            encryptedPacket = new byte[packet.length];
        }
        this.m_channelSymCipher.encryptAES1(packet, alreadyEncryptedBytes, encryptedPacket, alreadyEncryptedBytes, packet.length - alreadyEncryptedBytes);
        if (realPacketLength < encryptedPacket.length) {
            byte[] tempPacket = encryptedPacket;
            encryptedPacket = new byte[realPacketLength];
            System.arraycopy(tempPacket, 0, encryptedPacket, 0, realPacketLength);
        }
        return encryptedPacket;
    }

    public boolean decrypt(byte[] a_packet) {
        this.m_channelSymCipher.encryptAES2(a_packet);
        return true;
    }

    public int getNextPacketEncryptionOverhead() {
        int overhead = 0;
        if (this.m_firstEncryptionPacket) {
            overhead = this.m_channelSymCipher.getKeys().length;
        }
        return overhead;
    }

    private class MixEncryptionHandler
    implements ISendCallbackHandler {
        private SymCipher m_mixStreamCipher;
        private int m_bytesToEncrypt;

        public MixEncryptionHandler(SymCipher a_mixStreamCipher, int a_bytesToEncrypt) {
            this.m_mixStreamCipher = a_mixStreamCipher;
            this.m_bytesToEncrypt = a_bytesToEncrypt;
        }

        public void finalizePacket(MixPacket a_mixPacket) {
            this.m_mixStreamCipher.encryptAES1(a_mixPacket.getPayloadData(), 0, a_mixPacket.getPayloadData(), 0, this.m_bytesToEncrypt);
        }
    }
}

