/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPrivateKey;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureCreationAlgorithm;
import anon.crypto.MyECDSASignature;
import anon.crypto.MyECParams;
import anon.crypto.MyECPublicKey;
import anon.util.XMLParseException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class MyECPrivateKey
extends AbstractPrivateKey
implements IMyPrivateKey {
    private BigInteger m_D;
    private MyECParams m_params;

    public MyECPrivateKey(ECPrivateKeyParameters params, ASN1ObjectIdentifier curveId) {
        this.m_D = params.getD();
        this.m_params = new MyECParams(params.getParameters());
        this.m_params.setNamedCurveID(curveId);
    }

    public MyECPrivateKey(PrivateKeyInfo privKeyInfo) throws InvalidKeyException {
        super(privKeyInfo);
        try {
            AlgorithmIdentifier algId = privKeyInfo.getPrivateKeyAlgorithm();
            ECPrivateKeyStructure ecpks = new ECPrivateKeyStructure((ASN1Sequence)privKeyInfo.getPrivateKey());
            this.m_D = ecpks.getKey();
            this.m_params = new MyECParams(X962Parameters.getInstance(algId.getParameters()));
        }
        catch (Exception e) {
            throw new InvalidKeyException("IOException while decoding private key");
        }
    }

    public MyECPrivateKey(Element a_xmlElement) throws InvalidKeyException, XMLParseException {
    }

    public IMyPublicKey createPublicKey() {
        ECPoint Q = this.m_params.getECDomainParams().getG().multiply(this.m_D);
        MyECPublicKey key = new MyECPublicKey(new ECPublicKeyParameters(Q, this.m_params.getECDomainParams()));
        key.setNamedCurveID(this.m_params.getCurveID());
        return key;
    }

    public PrivateKeyInfo getAsPrivateKeyInfo() {
        PrivateKeyInfo info;
        ASN1Primitive derParam = this.m_params.getX962Params().toASN1Primitive();
        try {
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, derParam), new ECPrivateKeyStructure(this.m_D).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
        return info;
    }

    public ISignatureCreationAlgorithm getSignatureAlgorithm() {
        try {
            MyECDSASignature algorithm = new MyECDSASignature();
            algorithm.initSign(this);
            return algorithm;
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public String getAlgorithm() {
        return "Elliptic Curve Cryptography";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public Element toXmlElement(Document a_doc) {
        return null;
    }

    public ECPrivateKeyParameters getPrivateParams() {
        return new ECPrivateKeyParameters(this.m_D, this.m_params.getECDomainParams());
    }
}

