/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPrivateKey;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureCreationAlgorithm;
import anon.crypto.MyRSAPublicKey;
import anon.crypto.MyRSASignature;
import anon.util.Base64;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MyRSAPrivateKey
extends AbstractPrivateKey
implements IMyPrivateKey {
    public static final String XML_ELEMENT_NAME = "RSAPrivateKey";
    private MyRSASignature m_algorithm = new MyRSASignature();
    private RSAPrivateCrtKeyParameters m_Params;

    public MyRSAPrivateKey(CipherParameters cipherparams) throws Exception {
        this.m_Params = (RSAPrivateCrtKeyParameters)cipherparams;
    }

    public MyRSAPrivateKey(PrivateKeyInfo privKeyInfo) throws Exception {
        super(privKeyInfo);
        ASN1Primitive d = privKeyInfo.getPrivateKey();
        RSAPrivateKeyStructure gh = new RSAPrivateKeyStructure((ASN1Sequence)d);
        this.m_Params = new RSAPrivateCrtKeyParameters(gh.getModulus(), gh.getPublicExponent(), gh.getPrivateExponent(), gh.getPrime1(), gh.getPrime2(), gh.getExponent1(), gh.getExponent2(), gh.getCoefficient());
    }

    public MyRSAPrivateKey(Element a_xmlElement) throws Exception {
        if (a_xmlElement == null || !a_xmlElement.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException(XML_ELEMENT_NAME, "Element is null or has wrong name!");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "Modulus");
        String str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger modulus = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "PublicExponent");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger publicExponent = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "PrivateExponent");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger privateExponent = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "P");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger p = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "Q");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger q = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "dP");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger dP = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "dQ");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger dQ = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "QInv");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger qInv = new BigInteger(Base64.decode(str));
        this.m_Params = new RSAPrivateCrtKeyParameters(modulus, publicExponent, privateExponent, p, q, dP, dQ, qInv);
    }

    public MyRSAPrivateKey(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) throws Exception {
        this.m_Params = new RSAPrivateCrtKeyParameters(modulus, publicExponent, privateExponent, p, q, dP, dQ, qInv);
    }

    public ISignatureCreationAlgorithm getSignatureAlgorithm() {
        try {
            this.m_algorithm.initSign(this);
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return this.m_algorithm;
    }

    public IMyPublicKey createPublicKey() {
        return new MyRSAPublicKey(this.getModulus(), this.getPublicExponent());
    }

    public CipherParameters getParams() {
        return this.m_Params;
    }

    public BigInteger getModulus() {
        return this.m_Params.getModulus();
    }

    public BigInteger getPrivateExponent() {
        return this.m_Params.getExponent();
    }

    public BigInteger getP() {
        return this.m_Params.getP();
    }

    public BigInteger getQ() {
        return this.m_Params.getQ();
    }

    public BigInteger getDP() {
        return this.m_Params.getDP();
    }

    public BigInteger getDQ() {
        return this.m_Params.getDQ();
    }

    public BigInteger getQInv() {
        return this.m_Params.getQInv();
    }

    public BigInteger getPublicExponent() {
        return this.m_Params.getPublicExponent();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public PrivateKeyInfo getAsPrivateKeyInfo() {
        PrivateKeyInfo privKey;
        try {
            privKey = new PrivateKeyInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1")), new RSAPrivateKeyStructure(this.m_Params.getModulus(), this.m_Params.getPublicExponent(), this.m_Params.getExponent(), this.m_Params.getP(), this.m_Params.getQ(), this.m_Params.getDP(), this.m_Params.getDQ(), this.m_Params.getQInv()).toASN1Primitive());
        }
        catch (IOException e) {
            return null;
        }
        return privKey;
    }

    public Element toXmlElement(Document a_doc) {
        Element elemPrivKey = a_doc.createElement(XML_ELEMENT_NAME);
        Element elem = a_doc.createElement("Modulus");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getModulus().toByteArray()));
        elem = a_doc.createElement("PublicExponent");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getPublicExponent().toByteArray()));
        elem = a_doc.createElement("PrivateExponent");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getExponent().toByteArray()));
        elem = a_doc.createElement("P");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getP().toByteArray()));
        elem = a_doc.createElement("Q");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getQ().toByteArray()));
        elem = a_doc.createElement("dP");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getDP().toByteArray()));
        elem = a_doc.createElement("dQ");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getDQ().toByteArray()));
        elem = a_doc.createElement("QInv");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Params.getQInv().toByteArray()));
        return elemPrivKey;
    }
}

