/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.CertificationRequest;
import anon.crypto.CertificationRequestInfo;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.util.Base64;
import anon.util.ResourceLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public final class PKCS10CertificationRequest {
    public static final String FILE_EXTENSION = ".csr";
    private static final String BASE64_TAG = "CERTIFICATE REQUEST";
    private static final String BASE64_ALTERNATIVE_TAG = "NEW CERTIFICATE REQUEST";
    private CertificationRequest m_certificationRequest;
    private String m_sha1Fingerprint;
    private String m_md5Fingerprint;

    public PKCS10CertificationRequest(InputStream a_inputStream) throws IOException {
        this(ResourceLoader.getStreamAsBytes(a_inputStream));
    }

    public PKCS10CertificationRequest(byte[] a_bytes) {
        ASN1Sequence certificateRequest = JAPCertificate.toASN1Sequence(a_bytes, null);
        this.m_certificationRequest = new CertificationRequest(certificateRequest);
        this.createFingerprints();
    }

    public PKCS10CertificationRequest(X509DistinguishedName a_subject, AsymmetricCryptoKeyPair a_keyPair, MyX509Extensions a_extensions) {
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(a_subject, a_keyPair.getPublic(), a_extensions);
        this.m_certificationRequest = new CertificationRequest(certificationRequestInfo, a_keyPair);
        this.createFingerprints();
    }

    public PKCS10CertificationRequest(PKCS12 a_privateCertificate) {
        this(a_privateCertificate.getSubject(), a_privateCertificate.getKeyPair(), a_privateCertificate.getExtensions());
    }

    public void toOutputStream(OutputStream a_out, boolean a_Base64Encoded) throws IOException {
        a_out.write(this.toByteArray(a_Base64Encoded));
    }

    public byte[] toByteArray(boolean a_Base64Encoded) {
        if (a_Base64Encoded) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                out.write(Base64.encode(this.getEncoded(), true).getBytes());
                out.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException a_e) {
                throw new RuntimeException("Could not write encoded bytes to byte array: " + a_e.getMessage());
            }
            return out.toByteArray();
        }
        return this.getEncoded();
    }

    public boolean verify() {
        return this.m_certificationRequest.verify();
    }

    public JAPCertificate createX509Certificate(PKCS12 a_signerCertificate, Validity a_validity, MyX509Extensions a_extensions, BigInteger a_serialNumber) {
        return JAPCertificate.getInstance(this.getX509DistinguishedName(), a_signerCertificate.getSubject(), a_signerCertificate.getPrivateKey(), a_signerCertificate.getPublicKey(), a_validity, a_extensions, a_serialNumber);
    }

    public IMyPublicKey getPublicKey() {
        return this.m_certificationRequest.getPublicKey();
    }

    public String getSHA1Fingerprint() {
        return this.m_sha1Fingerprint;
    }

    public String getMD5Fingerprint() {
        return this.m_md5Fingerprint;
    }

    public X509DistinguishedName getX509DistinguishedName() {
        return this.m_certificationRequest.getCertificationRequestInfo().getX509DistinguishedName();
    }

    public MyX509Extensions getExtensions() {
        return this.m_certificationRequest.getCertificationRequestInfo().getExtensions();
    }

    private void createFingerprints() {
        byte[] data = this.toByteArray(false);
        this.m_sha1Fingerprint = JAPCertificate.createFingerprint(new SHA1Digest(), data);
        this.m_md5Fingerprint = JAPCertificate.createFingerprint(new MD5Digest(), data);
    }

    private byte[] getEncoded() {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DEROutputStream derOut = new DEROutputStream(bytesOut);
        try {
            derOut.writeObject(this.m_certificationRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return bytesOut.toByteArray();
    }
}

