/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import HTTPClient.ThreadInterruptedIOException;
import anon.infoservice.Database;
import anon.infoservice.ImmutableListenerInterface;
import anon.util.ClassUtil;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ListenerInterface
implements ImmutableListenerInterface,
IXMLEncodable {
    public static final int PORT_MIN_VALUE = 1;
    public static final int PORT_MAX_VALUE = 65535;
    public static final String XML_ELEMENT_NAME = "ListenerInterface";
    public static final String XML_ELEMENT_CONTAINER_NAME = "ListenerInterfaces";
    public static final String XML_ATTR_HIDDEN = "hidden";
    public static final String XML_ATTR_VIRTUAL = "virtual";
    public static final String XML_ELEM_HOST = "Host";
    public static final String XML_ELEM_PORT = "Port";
    public static final String XML_ELEM_FILE = "File";
    private long m_endOfBlocking = 0L;
    private String m_strHostname;
    private int m_iInetPort;
    private int m_iProtocolType;
    private boolean m_bUseInterface = false;
    private boolean m_bVirtual = false;
    private boolean m_bHidden = false;
    static /* synthetic */ Class class$anon$infoservice$ListenerInterface$IListenerInterfaceGetter;

    public ListenerInterface(Element listenerInterfaceNode) throws XMLParseException {
        String strHostname;
        String strProtocol;
        this.m_bHidden = XMLUtil.parseAttribute((Node)listenerInterfaceNode, XML_ATTR_HIDDEN, false);
        this.m_bVirtual = XMLUtil.parseAttribute((Node)listenerInterfaceNode, XML_ATTR_VIRTUAL, false);
        if (this.m_bVirtual && this.m_bHidden) {
            this.m_bHidden = false;
            this.m_bVirtual = false;
        }
        if ((strProtocol = XMLUtil.parseValue(XMLUtil.getFirstChildByName(listenerInterfaceNode, "Type"), null)) == null) {
            strProtocol = XMLUtil.parseValue(XMLUtil.getFirstChildByName(listenerInterfaceNode, "NetworkProtocol"), null);
        }
        this.setProtocol(strProtocol);
        if (this.getProtocol() == 5) {
            strHostname = XMLUtil.parseValue(XMLUtil.getFirstChildByName(listenerInterfaceNode, XML_ELEM_FILE), null);
        } else {
            Node hostNode = XMLUtil.getFirstChildByName(listenerInterfaceNode, XML_ELEM_HOST);
            Node ipNode = XMLUtil.getFirstChildByName(listenerInterfaceNode, "IP");
            if (hostNode == null && ipNode == null) {
                throw new XMLParseException("Host,IP", "Neither Host nor IP are given.");
            }
            strHostname = XMLUtil.parseValue(hostNode, null);
            if (!ListenerInterface.isValidHostname(strHostname) && !ListenerInterface.isValidIP(strHostname = XMLUtil.parseValue(ipNode, null))) {
                throw new XMLParseException("Host, IP", "Invalid Host and IP.");
            }
        }
        this.setHostname(strHostname);
        this.setPort(XMLUtil.parseValue(XMLUtil.getFirstChildByName(listenerInterfaceNode, XML_ELEM_PORT), -1));
        this.setUseInterface(true);
    }

    public ListenerInterface(String a_hostname, int a_port) throws IllegalArgumentException {
        this(a_hostname, a_port, 1);
    }

    public ListenerInterface(String a_strValue) throws IllegalArgumentException {
        if (a_strValue == null) {
            throw new IllegalArgumentException("Argument given to ListenInterface constructor is NULL!");
        }
        int delimiter = a_strValue.indexOf(":");
        int listenPort = -1;
        String listenHost = null;
        try {
            listenPort = Integer.parseInt(a_strValue.substring(delimiter + 1, a_strValue.length()));
        }
        catch (Exception a_e) {
            LogHolder.log(4, LogType.MISC, "Could not parse listener port: ", a_e);
        }
        if (delimiter > 0) {
            listenHost = a_strValue.substring(0, delimiter);
        }
        this.setHostname(listenHost);
        this.setPort(listenPort);
        this.setProtocol(1);
        this.setUseInterface(true);
    }

    public ListenerInterface(String a_hostname, int a_port, int a_protocol) throws IllegalArgumentException {
        this.setHostname(a_hostname);
        this.setPort(a_port);
        this.setProtocol(a_protocol);
        this.setUseInterface(true);
    }

    public static boolean isValidPort(int a_port) {
        return a_port >= 1 && a_port <= 65535;
    }

    public static boolean isValidProtocol(String a_protocol) {
        return ListenerInterface.recognizeProtocol(a_protocol) != -1;
    }

    public static boolean isValidProtocol(int a_protocol) {
        return ListenerInterface.recognizeProtocol(a_protocol) != -1;
    }

    public static boolean isValidHostname(String a_hostname) {
        return a_hostname != null && a_hostname.trim().length() > 0;
    }

    public static boolean isValidIP(String a_ipAddress) {
        if (a_ipAddress == null || a_ipAddress.indexOf(45) != -1) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(a_ipAddress, ".");
        try {
            if (tokenizer.countTokens() != 4 && tokenizer.countTokens() != 16) {
                throw new NumberFormatException();
            }
            while (tokenizer.hasMoreTokens()) {
                if (new Integer(tokenizer.nextToken()) <= 255) continue;
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException a_e) {
            return false;
        }
        return true;
    }

    public int getProtocol() {
        return this.m_iProtocolType;
    }

    public String getProtocolAsString() {
        switch (this.m_iProtocolType) {
            case 2: {
                return "RAW/TCP";
            }
            case 3: {
                return "socks";
            }
            case 4: {
                return "https";
            }
            case 1: {
                return "HTTP/TCP";
            }
            case 5: {
                return "RAW/UNIX";
            }
        }
        return "UNKNWON/UNKNOWN";
    }

    public String getHost() {
        return this.m_strHostname;
    }

    public int getPort() {
        return this.m_iInetPort;
    }

    public String getId() {
        String strID = "";
        if (this.getHost() != null) {
            strID = strID + this.getHost() + "_";
        }
        strID = strID + this.getPort() + "_";
        strID = strID + this.getProtocol() + "_";
        return strID;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object a_listenerInterface) {
        if (a_listenerInterface != null && a_listenerInterface instanceof ListenerInterface) {
            return this.equals((ListenerInterface)a_listenerInterface);
        }
        return false;
    }

    private boolean equals(ListenerInterface a_listenerInterface) {
        if (this == a_listenerInterface) {
            return true;
        }
        if (!Util.equals(this.getHost(), a_listenerInterface.getHost())) {
            return false;
        }
        return this.getPort() == a_listenerInterface.getPort() && this.getProtocol() == a_listenerInterface.getProtocol();
    }

    public Element toXmlElement(Document a_doc) {
        return this.toXmlElementInternal(a_doc, XML_ELEMENT_NAME);
    }

    public void setUseInterface(boolean a_bUseInterface) {
        this.m_bUseInterface = a_bUseInterface;
        if (a_bUseInterface) {
            this.m_endOfBlocking = 0L;
        }
    }

    public static boolean isBlockingRecommended(Throwable a_e) {
        boolean bBlock = false;
        Class<?> classSocketTimeoutException = null;
        try {
            classSocketTimeoutException = Class.forName("java.net.SocketTimeoutException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (a_e == null) {
            return false;
        }
        if (a_e instanceof ConnectException) {
            bBlock = true;
        } else if (classSocketTimeoutException != null && classSocketTimeoutException.isAssignableFrom(a_e.getClass())) {
            bBlock = true;
        } else if (a_e instanceof InterruptedIOException && !(a_e instanceof ThreadInterruptedIOException) && a_e.getMessage() != null && a_e.getMessage().indexOf("timed out") >= 0) {
            bBlock = true;
        }
        return bBlock;
    }

    public long getBlockingTimeRemaining() {
        return Math.max(0L, this.m_endOfBlocking - System.currentTimeMillis());
    }

    public void blockInterface(long a_blockingTime) {
        long lBlockingTime = System.currentTimeMillis() + a_blockingTime;
        if (lBlockingTime < a_blockingTime) {
            lBlockingTime = Long.MAX_VALUE;
        }
        if (a_blockingTime > 0L) {
            if (lBlockingTime > this.m_endOfBlocking) {
                this.m_endOfBlocking = lBlockingTime;
                LogHolder.log(4, LogType.NET, "Blocked interface: " + this.toString());
            }
        } else if (this.m_endOfBlocking - System.currentTimeMillis() > 0L) {
            this.m_endOfBlocking = 0L;
            LogHolder.log(4, LogType.NET, "Unblocked/Released interface: " + this.toString());
        }
    }

    public boolean isValid() {
        return ListenerInterface.isValidPort(this.getPort()) && ListenerInterface.isValidHostname(this.getHost()) && this.m_bUseInterface && this.m_endOfBlocking <= System.currentTimeMillis();
    }

    public boolean isVirtual() {
        return this.m_bVirtual;
    }

    public boolean isHidden() {
        return this.m_bHidden;
    }

    protected static int recognizeProtocol(String a_protocol) {
        int iProtocol = -1;
        if (a_protocol != null) {
            if (a_protocol.equalsIgnoreCase("HTTP/TCP")) {
                iProtocol = 1;
            } else if (a_protocol.equalsIgnoreCase("https")) {
                iProtocol = 4;
            } else if (a_protocol.equalsIgnoreCase("socks")) {
                iProtocol = 3;
            } else if (a_protocol.equalsIgnoreCase("RAW/TCP")) {
                iProtocol = 2;
            } else if (a_protocol.equalsIgnoreCase("RAW/UNIX")) {
                iProtocol = 5;
            }
        }
        return iProtocol;
    }

    protected static int recognizeProtocol(int a_protocol) {
        if (a_protocol == 1 || a_protocol == 4 || a_protocol == 2 || a_protocol == 3) {
            return a_protocol;
        }
        return -1;
    }

    public void setProtocol(String a_protocol) {
        if (!ListenerInterface.isValidProtocol(a_protocol)) {
            if (ListenerInterface.isValidHostname(this.getHost())) {
                LogHolder.log(5, LogType.NET, "Host " + this.getHost() + " has listener with " + "invalid protocol '" + a_protocol + "'!");
            }
            this.m_iProtocolType = 2;
        } else {
            this.m_iProtocolType = ListenerInterface.recognizeProtocol(a_protocol);
        }
    }

    public void setProtocol(int a_protocol) {
        if (!ListenerInterface.isValidProtocol(a_protocol)) {
            if (ListenerInterface.isValidHostname(this.getHost())) {
                LogHolder.log(5, LogType.NET, "Host " + this.getHost() + " has listener with " + "invalid protocol '" + a_protocol + "'!");
            }
            this.m_iProtocolType = 2;
        } else {
            this.m_iProtocolType = ListenerInterface.recognizeProtocol(a_protocol);
        }
    }

    public void setPort(int a_port) {
        this.m_iInetPort = !ListenerInterface.isValidPort(a_port) ? -1 : a_port;
    }

    public void setHostname(String a_strHostname) {
        if (!ListenerInterface.isValidHostname(a_strHostname)) {
            LogHolder.log(5, LogType.NET, "Invalid host name: '" + a_strHostname + "'");
        } else {
            this.m_strHostname = a_strHostname.toLowerCase();
        }
    }

    public Vector toVector() {
        Vector<ListenerInterface> listeners = new Vector<ListenerInterface>();
        listeners.addElement(this);
        return listeners;
    }

    protected Element toXmlElementInternal(Document doc, String a_strXmlElementName) {
        Element hostNode;
        Element listenerInterfaceNode = doc.createElement(a_strXmlElementName);
        Element typeNode = doc.createElement("Type");
        Element portNode = null;
        XMLUtil.setValue((Node)typeNode, this.getProtocolAsString());
        if (this.getProtocol() == 5) {
            hostNode = doc.createElement(XML_ELEM_FILE);
            XMLUtil.setValue((Node)hostNode, this.m_strHostname);
        } else {
            portNode = doc.createElement(XML_ELEM_PORT);
            XMLUtil.setValue((Node)portNode, this.m_iInetPort);
            hostNode = doc.createElement(XML_ELEM_HOST);
            XMLUtil.setValue((Node)hostNode, this.m_strHostname);
        }
        if (this.m_bHidden) {
            XMLUtil.setAttribute(listenerInterfaceNode, XML_ATTR_HIDDEN, this.m_bHidden);
        } else if (this.m_bVirtual) {
            XMLUtil.setAttribute(listenerInterfaceNode, XML_ATTR_VIRTUAL, this.m_bVirtual);
        }
        listenerInterfaceNode.appendChild(typeNode);
        if (portNode != null) {
            listenerInterfaceNode.appendChild(portNode);
        }
        listenerInterfaceNode.appendChild(hostNode);
        return listenerInterfaceNode;
    }

    public String toString() {
        return "ListenerInterface (Protocol: " + this.getProtocolAsString() + ")- Host: " + this.getHost() + " Port: " + this.getPort() + " Valid: " + this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unblockInterfacesFromDatabase(Class a_classIListenerInterfaceGetter) {
        if (a_classIListenerInterfaceGetter == null || !(class$anon$infoservice$ListenerInterface$IListenerInterfaceGetter == null ? (class$anon$infoservice$ListenerInterface$IListenerInterfaceGetter = ListenerInterface.class$("anon.infoservice.ListenerInterface$IListenerInterfaceGetter")) : class$anon$infoservice$ListenerInterface$IListenerInterfaceGetter).isAssignableFrom(a_classIListenerInterfaceGetter)) {
            LogHolder.log(3, LogType.MISC, "Tried to unblock network interfaces for incompatible class: " + a_classIListenerInterfaceGetter);
            return;
        }
        Database database = Database.getInstance(a_classIListenerInterfaceGetter);
        synchronized (database) {
            Enumeration enumCascades = Database.getInstance(a_classIListenerInterfaceGetter).getEntrySnapshotAsEnumeration();
            while (enumCascades.hasMoreElements()) {
                Vector vecListenerInterfaces = ((IListenerInterfaceGetter)enumCascades.nextElement()).getListenerInterfaces();
                if (vecListenerInterfaces == null) continue;
                for (int i = 0; i < vecListenerInterfaces.size(); ++i) {
                    ListenerInterface listenerInterface = (ListenerInterface)vecListenerInterfaces.elementAt(i);
                    listenerInterface.blockInterface(0L);
                }
            }
        }
    }

    public static void blockInterfacesFromDatabase(IListenerInterfaceGetter a_listenerInterfaceGetter) {
        IListenerInterfaceGetter isOld = (IListenerInterfaceGetter)((Object)Database.getInstance(a_listenerInterfaceGetter.getClass()).getEntryById(a_listenerInterfaceGetter.getId()));
        if (isOld != null) {
            Vector vecListenerInterfacesOld = isOld.getListenerInterfaces();
            for (int i = 0; vecListenerInterfacesOld != null && i < vecListenerInterfacesOld.size(); ++i) {
                ListenerInterface listenerInterface = (ListenerInterface)vecListenerInterfacesOld.elementAt(i);
                if (a_listenerInterfaceGetter.getListenerInterface(listenerInterface.getId()) == null || listenerInterface.getBlockingTimeRemaining() <= 0L) continue;
                a_listenerInterfaceGetter.getListenerInterface(listenerInterface.getId()).blockInterface(listenerInterface.getBlockingTimeRemaining());
                LogHolder.log(4, LogType.NET, "Blocked interface " + listenerInterface.getId() + " of " + ClassUtil.getShortClassName(a_listenerInterfaceGetter.getClass()) + " " + a_listenerInterfaceGetter.getId() + ".");
            }
        }
    }

    public static ListenerInterface parseHostnamePort(String a_hostNamePort) throws IllegalArgumentException, NumberFormatException {
        return ListenerInterface.parseHostnamePort(a_hostNamePort, 1);
    }

    public static ListenerInterface parseHostnamePort(String a_hostNamePort, int a_protocol) throws IllegalArgumentException, NumberFormatException {
        String strHost = null;
        int port = -1;
        if (a_hostNamePort != null && a_hostNamePort.trim().length() > 0) {
            int index = (a_hostNamePort = a_hostNamePort.trim()).lastIndexOf(":");
            if (index == a_hostNamePort.length() - 1) {
                throw new IllegalArgumentException("Definition of [hostname]:[port] is invalid: " + a_hostNamePort);
            }
            if (index == 0) {
                port = Integer.parseInt(a_hostNamePort.substring(index + 1, a_hostNamePort.length()));
            } else if (index < 0) {
                strHost = a_hostNamePort;
            } else {
                strHost = a_hostNamePort.substring(0, index);
                port = Integer.parseInt(a_hostNamePort.substring(index + 1, a_hostNamePort.length()));
            }
        }
        return new ListenerInterface(strHost, port, a_protocol);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface IListenerInterfaceGetter {
        public Vector getListenerInterfaces();

        public String getId();

        public ListenerInterface getListenerInterface(String var1);
    }
}

