/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.pay.xml.XMLPaymentOption;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPaymentOptions
implements IXMLEncodable {
    private Vector m_currencies = new Vector();
    private Vector m_paymentOptions = new Vector();
    private String m_acceptedCreditCards;
    private String m_sortingLanguage = null;

    public XMLPaymentOptions(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
    }

    public XMLPaymentOptions() {
    }

    public XMLPaymentOptions(Element xml) throws Exception {
        this.setValues(xml);
    }

    public Element toXmlElement(Document a_doc) {
        Element elem;
        int i;
        Element elemRoot = a_doc.createElement("PaymentOptions");
        elemRoot.setAttribute("version", "1.0");
        for (i = 0; i < this.m_currencies.size(); ++i) {
            elem = a_doc.createElement("Currency");
            elem.appendChild(a_doc.createTextNode((String)this.m_currencies.elementAt(i)));
            elemRoot.appendChild(elem);
        }
        for (i = 0; i < this.m_paymentOptions.size(); ++i) {
            try {
                XMLPaymentOption anOption = (XMLPaymentOption)this.m_paymentOptions.elementAt(i);
                elem = anOption.toXmlElement(a_doc);
                elemRoot.appendChild(elem);
                continue;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        elem = a_doc.createElement("AcceptedCards");
        elem.appendChild(a_doc.createTextNode(this.m_acceptedCreditCards));
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    private void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals("PaymentOptions")) {
            throw new Exception("XMLPaymentOptions wrong XML structure");
        }
        NodeList currencies = elemRoot.getElementsByTagName("Currency");
        for (int i = 0; i < currencies.getLength(); ++i) {
            this.m_currencies.addElement(currencies.item(i).getFirstChild().getNodeValue());
        }
        NodeList options = elemRoot.getElementsByTagName("PaymentOption");
        for (int i = 0; i < options.getLength(); ++i) {
            XMLPaymentOption anOption = new XMLPaymentOption((Element)options.item(i));
            this.m_paymentOptions.addElement(anOption);
        }
        Node node = XMLUtil.getFirstChildByName(elemRoot, "AcceptedCards");
        this.m_acceptedCreditCards = XMLUtil.parseValue(node, "");
    }

    public XMLPaymentOptions(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
    }

    public void addOption(XMLPaymentOption a_option) {
        this.m_paymentOptions.addElement(a_option);
    }

    public void addCurrency(String a_currency) {
        this.m_currencies.addElement(a_currency);
    }

    public Vector getAllOptions() {
        return this.getAllOptionsSortedByRank("en");
    }

    public synchronized Vector getAllOptionsSortedByRank(String a_lang) {
        this.setSortingLanguage(a_lang);
        this.sortVector();
        Vector sortedOptions = (Vector)this.m_paymentOptions.clone();
        return sortedOptions;
    }

    public XMLPaymentOption getOption(String a_name) {
        for (int i = 0; i < this.m_paymentOptions.size(); ++i) {
            try {
                XMLPaymentOption option = (XMLPaymentOption)this.m_paymentOptions.elementAt(i);
                if (!option.getName().equalsIgnoreCase(a_name)) continue;
                return option;
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.PAY, "Could not get payment option with name: " + a_name);
            }
        }
        LogHolder.log(5, LogType.PAY, "Could not get payment option with name: " + a_name);
        return null;
    }

    public XMLPaymentOption getOption(String a_heading, String a_language) {
        for (int i = 0; i < this.m_paymentOptions.size(); ++i) {
            try {
                XMLPaymentOption option = (XMLPaymentOption)this.m_paymentOptions.elementAt(i);
                String heading = option.getHeading(a_language);
                if (!heading.equalsIgnoreCase(a_heading)) continue;
                return option;
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.PAY, "Could not get payment option for heading: " + a_heading + " in language " + a_language);
            }
        }
        LogHolder.log(5, LogType.PAY, "Could not get payment option for heading: " + a_heading + " in language " + a_language);
        return null;
    }

    public Vector getCurrencies() {
        return (Vector)this.m_currencies.clone();
    }

    public void setAcceptedCreditCards(String a_acceptedCreditCards) {
        this.m_acceptedCreditCards = a_acceptedCreditCards;
    }

    public String getAcceptedCreditCards() {
        return this.m_acceptedCreditCards;
    }

    public int compare(Object object1, Object object2) {
        XMLPaymentOption optionTwo;
        XMLPaymentOption optionOne;
        try {
            if (object1 == null || object2 == null) {
                throw new Exception("can not compare null objects");
            }
            optionOne = (XMLPaymentOption)object1;
            optionTwo = (XMLPaymentOption)object2;
        }
        catch (Exception e) {
            throw new ClassCastException("could not compare payment options, incompatible objects?" + e);
        }
        String sortingLang = this.m_sortingLanguage;
        if (sortingLang == null || optionOne.getRank(sortingLang) == null || optionTwo.getRank(sortingLang) == null) {
            sortingLang = "en";
        }
        Integer rankOne = optionOne.getRank(sortingLang);
        Integer rankTwo = optionTwo.getRank(sortingLang);
        if (rankOne == null || rankTwo == null) {
            return 0;
        }
        if (rankOne < rankTwo) {
            return -1;
        }
        if (rankOne > rankTwo) {
            return 1;
        }
        return 0;
    }

    public void setSortingLanguage(String a_lang) {
        this.m_sortingLanguage = a_lang;
    }

    private void sortVector() {
        Vector optionsToSort = (Vector)this.m_paymentOptions.clone();
        Vector<XMLPaymentOption> sortedOptions = new Vector<XMLPaymentOption>();
        Enumeration allOptions = optionsToSort.elements();
        while (allOptions.hasMoreElements()) {
            XMLPaymentOption newOption = (XMLPaymentOption)allOptions.nextElement();
            boolean wasInserted = false;
            for (int i = 0; i < sortedOptions.size(); ++i) {
                XMLPaymentOption curOption = (XMLPaymentOption)sortedOptions.elementAt(i);
                if (this.compare(newOption, curOption) >= 0) continue;
                sortedOptions.insertElementAt(newOption, i);
                wasInserted = true;
                break;
            }
            if (wasInserted) continue;
            sortedOptions.addElement(newOption);
        }
        this.m_paymentOptions = sortedOptions;
    }
}

