/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.crypto.SignatureCreator;
import anon.crypto.XMLSignature;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static final int STORAGE_MODE_NORMAL = 0;
    public static final int STORAGE_MODE_OPTIMIZED = 1;
    public static final int STORAGE_MODE_AGRESSIVE = 2;
    private static final String DEFAULT_FORMAT_SPACE = "    ";
    private static final String XML_STR_BOOLEAN_TRUE = "true";
    private static final String XML_STR_BOOLEAN_FALSE = "false";
    private static final String PACKAGE_TRANSFORMER = "javax.xml.transform.";
    private static final String HIERARCHY_REQUEST_ERR = "HIERARCHY_REQUEST_ERR: ";
    private static DocumentBuilderFactory ms_DocumentBuilderFactory;
    private static boolean m_bCheckedHumanReadableFormatting;
    private static boolean m_bNeedsHumanReadableFormatting;
    private static int ms_storageMode;
    public static final String[] SPECIAL_CHARS;
    public static final String[] ENTITIES;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$lang$String;

    public static int getStorageMode() {
        return ms_storageMode;
    }

    public static void setStorageMode(int a_storageMode) {
        if (a_storageMode == 0 || a_storageMode == 1 || a_storageMode == 2) {
            ms_storageMode = a_storageMode;
        }
    }

    public static void assertNotNull(Node a_node) throws XMLParseException {
        if (a_node == null) {
            throw new XMLParseException("##__null__##");
        }
    }

    public static void assertNotNull(Node a_node, String a_attribute) throws XMLParseException {
        if (XMLUtil.parseAttribute(a_node, a_attribute, null) == null) {
            throw new XMLParseException("##__null__##");
        }
    }

    public static Node assertNodeName(Node a_node, String a_strExpectedName) throws XMLParseException {
        if (a_node == null) {
            throw new XMLParseException("##__null__##", "Expected node '" + a_strExpectedName + "' is NULL!");
        }
        if (!(a_node = XMLUtil.getDocumentElement(a_node)).getNodeName().equals(a_strExpectedName)) {
            String nodeName = a_node.getOwnerDocument().getDocumentElement() == a_node || a_node.getOwnerDocument() == a_node ? "##__root__##" : a_node.getNodeName();
            throw new XMLParseException(nodeName, "Node '" + a_node.getNodeName() + "' has not the expected name: '" + a_strExpectedName + "'");
        }
        return a_node;
    }

    public static Node getDocumentElement(Node a_node) {
        if (a_node instanceof Document) {
            a_node = ((Document)a_node).getDocumentElement();
        }
        return a_node;
    }

    public static int parseValue(Node a_node, int a_defaultValue) {
        int i = a_defaultValue;
        String s = XMLUtil.parseValue(a_node, null);
        if (s != null) {
            try {
                i = Integer.parseInt(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return i;
    }

    public static long parseValue(Node a_node, long a_defaultValue) {
        long i = a_defaultValue;
        String s = XMLUtil.parseValue(a_node, null);
        if (s != null) {
            try {
                i = Long.parseLong(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return i;
    }

    public static double parseValue(Node a_node, double a_defaultValue) {
        double i = a_defaultValue;
        String s = XMLUtil.parseValue(a_node, null);
        if (s != null) {
            try {
                i = Util.parseDouble(s);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return i;
    }

    public static String parseAttribute(Node a_node, String a_attribute, String a_default) {
        try {
            if (a_node instanceof Document) {
                a_node = ((Document)a_node).getDocumentElement();
            }
            Attr at = ((Element)a_node).getAttributeNode(a_attribute);
            return at.getValue().trim();
        }
        catch (Exception a_e) {
            return a_default;
        }
    }

    public static boolean parseAttribute(Node a_node, String a_attribute, boolean a_default) {
        boolean b = a_default;
        try {
            String tmpStr = XMLUtil.parseAttribute(a_node, a_attribute, null);
            if (tmpStr.equalsIgnoreCase(XML_STR_BOOLEAN_TRUE)) {
                b = true;
            } else if (tmpStr.equalsIgnoreCase(XML_STR_BOOLEAN_FALSE)) {
                b = false;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return b;
    }

    public static int parseAttribute(Node a_node, String a_attribute, int a_default) {
        int i = a_default;
        try {
            i = Integer.parseInt(XMLUtil.parseAttribute(a_node, a_attribute, null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        return i;
    }

    public static double parseAttribute(Node a_node, String a_attribute, double a_default) {
        double d = a_default;
        try {
            d = Util.parseDouble(XMLUtil.parseAttribute(a_node, a_attribute, null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        return d;
    }

    public static long parseAttribute(Node a_node, String a_attribute, long a_default) {
        long i = a_default;
        try {
            i = Long.parseLong(XMLUtil.parseAttribute(a_node, a_attribute, null));
        }
        catch (Exception ex) {
            // empty catch block
        }
        return i;
    }

    public static boolean parseValue(Node a_node, boolean a_defaultValue) {
        boolean b = a_defaultValue;
        try {
            String tmpStr = XMLUtil.parseValue(a_node, null);
            if (tmpStr == null) {
                return b;
            }
            if (tmpStr.equalsIgnoreCase(XML_STR_BOOLEAN_TRUE)) {
                b = true;
            } else if (tmpStr.equalsIgnoreCase(XML_STR_BOOLEAN_FALSE)) {
                b = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public static String parseValue(Node a_node, String a_defaultValue) {
        String s = a_defaultValue;
        if (a_node != null) {
            try {
                if (a_node.getNodeType() == 1) {
                    a_node = a_node.getFirstChild();
                }
                if (a_node.getNodeType() == 3 || a_node.getNodeType() == 5) {
                    s = "";
                    while (a_node != null && (a_node.getNodeType() == 5 || a_node.getNodeType() == 3)) {
                        s = a_node.getNodeType() == 5 ? s + a_node.getFirstChild().getNodeValue() : s + a_node.getNodeValue();
                        a_node = XMLUtil.getNextSibling(a_node);
                    }
                } else {
                    s = a_node.getNodeValue();
                }
            }
            catch (Exception e) {
                return a_defaultValue;
            }
        }
        return s;
    }

    public static String getXmlElementContainerName(Class a_xmlEncodableClass) {
        return Util.getStaticFieldValue(a_xmlEncodableClass, "XML_ELEMENT_CONTAINER_NAME");
    }

    public static String getXmlElementName(Class a_xmlEncodableClass) {
        return Util.getStaticFieldValue(a_xmlEncodableClass, "XML_ELEMENT_NAME");
    }

    public static Element[] readElementsByTagName(File a_file, String a_tagName) {
        int i;
        Vector<Element> vec = new Vector<Element>();
        if (a_file != null && a_tagName != null) {
            try {
                NodeList elements = XMLUtil.readXMLDocument(a_file).getDocumentElement().getElementsByTagName(a_tagName);
                for (i = 0; i < elements.getLength(); ++i) {
                    try {
                        vec.addElement((Element)elements.item(i));
                        continue;
                    }
                    catch (Exception a_e) {
                        LogHolder.log(2, LogType.MISC, a_e);
                    }
                }
            }
            catch (Exception ex) {
                LogHolder.log(2, LogType.MISC, ex);
            }
        }
        Element[] entries = new Element[vec.size()];
        for (i = 0; i < vec.size(); ++i) {
            entries[i] = (Element)vec.elementAt(i);
        }
        return entries;
    }

    public static NodeList getElementsByTagName(Node a_elementName, String a_tagName) {
        if (a_elementName == null || !(a_elementName instanceof Element) || a_tagName == null || a_tagName.trim().length() == 0) {
            return null;
        }
        return ((Element)a_elementName).getElementsByTagName(a_tagName);
    }

    public static Node getFirstChildByName(Node a_node, String a_childname) {
        try {
            Node child = a_node.getFirstChild();
            while (child != null) {
                if (child.getNodeName().equals(a_childname)) {
                    return child;
                }
                child = XMLUtil.getNextSibling(child);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Node getFirstChildByName(Node a_node, String a_childname, boolean a_bDeepSearch) {
        if (a_bDeepSearch) {
            return XMLUtil.getFirstChildByNameUsingDeepSearch(a_node, a_childname);
        }
        return XMLUtil.getFirstChildByName(a_node, a_childname);
    }

    public static Node getFirstChildByNameUsingDeepSearch(Node a_node, String a_childname) {
        Node result = null;
        try {
            a_node = a_node.getFirstChild();
            while (a_node != null && (result = XMLUtil.getFirstChildByNameUsingDeepSearchInternal(a_node, a_childname)) == null) {
                a_node = XMLUtil.getNextSibling(a_node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Node getLastChildByName(Node n, String name) {
        try {
            for (Node child = n.getLastChild(); child != null; child = child.getPreviousSibling()) {
                if (!child.getNodeName().equals(name)) continue;
                return child;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Node getNextSibling(Node a_node) {
        Node nextSibling = null;
        try {
            nextSibling = a_node.getNextSibling();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return nextSibling;
    }

    public static Node getNextSiblingByName(Node a_node, String a_siblingName) {
        try {
            if (a_node == null) {
                return null;
            }
            Node iterator = XMLUtil.getNextSibling(a_node);
            while (iterator != null) {
                if (iterator.getNodeName().equals(a_siblingName)) {
                    return iterator;
                }
                iterator = XMLUtil.getNextSibling(iterator);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void setValue(Node a_node, String a_value) {
        if (a_node == null || a_value == null) {
            return;
        }
        a_node.appendChild(a_node.getOwnerDocument().createTextNode(a_value));
    }

    public static void setValue(Node a_node, int a_value) {
        a_node.appendChild(a_node.getOwnerDocument().createTextNode(Integer.toString(a_value)));
    }

    public static void setValue(Node a_node, long a_value) {
        a_node.appendChild(a_node.getOwnerDocument().createTextNode(Long.toString(a_value)));
    }

    public static void setValue(Node a_node, double a_value) {
        a_node.appendChild(a_node.getOwnerDocument().createTextNode(Double.toString(a_value)));
    }

    public static void setValue(Node a_node, boolean a_bValue) {
        XMLUtil.setValue(a_node, a_bValue ? XML_STR_BOOLEAN_TRUE : XML_STR_BOOLEAN_FALSE);
    }

    public static void setAttribute(Element a_element, String a_attribute, String a_value) {
        if (a_value == null || a_attribute == null || a_element == null) {
            return;
        }
        a_element.setAttribute(a_attribute, a_value);
    }

    public static void setAttribute(Element a_element, String a_attribute, boolean a_value) {
        XMLUtil.setAttribute(a_element, a_attribute, a_value ? XML_STR_BOOLEAN_TRUE : XML_STR_BOOLEAN_FALSE);
    }

    public static void setAttribute(Element a_element, String a_attribute, int a_value) {
        XMLUtil.setAttribute(a_element, a_attribute, Integer.toString(a_value));
    }

    public static void setAttribute(Element a_element, String a_attribute, double a_value) {
        XMLUtil.setAttribute(a_element, a_attribute, Double.toString(a_value));
    }

    public static void setAttribute(Element a_element, String a_attribute, long a_value) {
        XMLUtil.setAttribute(a_element, a_attribute, Long.toString(a_value));
    }

    public static Document createDocument() {
        try {
            if (ms_DocumentBuilderFactory == null) {
                ms_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            return ms_DocumentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException a_e) {
            return null;
        }
    }

    public static Element createChildElementWithValue(Node a_parent, String a_nodeName, String a_value) {
        Element el = a_parent.getOwnerDocument().createElement(a_nodeName);
        XMLUtil.setValue((Node)el, a_value);
        a_parent.appendChild(el);
        return el;
    }

    public static Element createChildElement(Node a_parent, String a_nodeName) {
        Element el = a_parent.getOwnerDocument().createElement(a_nodeName);
        a_parent.appendChild(el);
        return el;
    }

    public static Node importNode(Document a_doc, Node a_source, boolean a_bDeep) throws XMLParseException {
        if (a_doc == null || a_source == null) {
            return null;
        }
        Node newnode = null;
        short type = a_source.getNodeType();
        switch (type) {
            case 1: {
                Element newelement = a_doc.createElement(a_source.getNodeName());
                NamedNodeMap srcattr = a_source.getAttributes();
                if (srcattr != null) {
                    for (int i = 0; i < srcattr.getLength(); ++i) {
                        newelement.setAttributeNode((Attr)XMLUtil.importNode(a_doc, srcattr.item(i), true));
                    }
                }
                newnode = newelement;
                break;
            }
            case 2: {
                newnode = a_doc.createAttribute(a_source.getNodeName());
                newnode.setNodeValue(a_source.getNodeValue());
                break;
            }
            case 3: {
                Node tmpParent = a_source.getParentNode();
                if (tmpParent != null && tmpParent.getNodeType() == 2) break;
                newnode = a_doc.createTextNode(a_source.getNodeValue());
                break;
            }
            case 4: {
                newnode = a_doc.createCDATASection(a_source.getNodeValue());
                break;
            }
            case 5: {
                newnode = a_doc.createEntityReference(a_source.getNodeName());
                a_bDeep = false;
                break;
            }
            case 6: {
                throw new XMLParseException(a_source.getNodeName(), "HIERARCHY_REQUEST_ERR: Entity");
            }
            case 7: {
                newnode = a_doc.createProcessingInstruction(a_source.getNodeName(), a_source.getNodeValue());
                break;
            }
            case 8: {
                newnode = a_doc.createComment(a_source.getNodeValue());
                break;
            }
            case 10: {
                throw new XMLParseException(a_source.getNodeName(), "HIERARCHY_REQUEST_ERR: DocumentType");
            }
            case 11: {
                newnode = a_doc.createDocumentFragment();
                break;
            }
            case 12: {
                throw new XMLParseException(a_source.getNodeName(), "HIERARCHY_REQUEST_ERR: Notation");
            }
            default: {
                throw new XMLParseException(a_source.getNodeName(), "HIERARCHY_REQUEST_ERR: Document");
            }
        }
        if (a_bDeep) {
            Node srckid = a_source.getFirstChild();
            while (srckid != null) {
                Node n;
                if (newnode != null && (n = XMLUtil.importNode(a_doc, srckid, true)) != null) {
                    newnode.appendChild(n);
                }
                srckid = XMLUtil.getNextSibling(srckid);
            }
        }
        return newnode;
    }

    public static byte[] toByteArray(Node a_inputNode) {
        byte[] bytes = null;
        try {
            bytes = XMLSignature.toCanonical(a_inputNode, true);
        }
        catch (Throwable a_e) {
            return null;
        }
        return bytes;
    }

    public static String toString(Node a_node) {
        String strXml;
        try {
            strXml = new String(XMLUtil.toByteArray(a_node), "UTF8");
        }
        catch (Exception a_e) {
            return null;
        }
        return strXml;
    }

    public static String quoteXML(String text) {
        String s = text;
        if (s.indexOf(38) >= 0 || s.indexOf(60) >= 0 || s.indexOf(62) >= 0) {
            StringBuffer sb = new StringBuffer(text);
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == '&') {
                    sb.insert(i, "amp;");
                    i += 4;
                    continue;
                }
                if (c == '<') {
                    sb.setCharAt(i, '&');
                    sb.insert(i + 1, "lt;");
                    i += 3;
                    continue;
                }
                if (c != '>') continue;
                sb.setCharAt(i, '&');
                sb.insert(i + 1, "gt;");
                i += 3;
            }
            return sb.toString();
        }
        return s;
    }

    public static void removeComments(Node a_node) {
        if (a_node == null) {
            return;
        }
        if (a_node.getNodeType() != 8) {
            XMLUtil.removeCommentsInternal(a_node, a_node);
        }
    }

    public static Document formatHumanReadable(Document a_doc) {
        XMLUtil.formatHumanReadable(a_doc.getDocumentElement(), 0);
        return a_doc;
    }

    public static Element formatHumanReadable(Element a_element) {
        XMLUtil.formatHumanReadable(a_element, 0);
        return a_element;
    }

    public static Document readXMLDocument(InputSource a_inputSource) throws IOException, XMLParseException {
        Document doc = null;
        try {
            if (ms_DocumentBuilderFactory == null) {
                ms_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            doc = ms_DocumentBuilderFactory.newDocumentBuilder().parse(a_inputSource);
        }
        catch (IOException a_e) {
            throw a_e;
        }
        catch (Exception a_e) {
            throw new XMLParseException("##__root__##", "Could not parse XML document: " + a_e.getMessage());
        }
        return doc;
    }

    public static Document readXMLDocument(InputStream a_inputStream) throws IOException, XMLParseException {
        return XMLUtil.readXMLDocument(new InputSource(a_inputStream));
    }

    public static Document readXMLDocument(Reader a_reader) throws IOException, XMLParseException {
        return XMLUtil.readXMLDocument(new InputSource(a_reader));
    }

    public static Document readXMLDocument(File a_file) throws IOException, XMLParseException {
        FileInputStream inputStream = new FileInputStream(a_file);
        IOException exIO = null;
        XMLParseException exXML = null;
        Document doc = null;
        try {
            doc = XMLUtil.readXMLDocument(inputStream);
        }
        catch (IOException a_e) {
            exIO = a_e;
        }
        catch (XMLParseException a_e) {
            exXML = a_e;
        }
        try {
            inputStream.close();
        }
        catch (IOException a_e) {
            // empty catch block
        }
        if (exIO != null) {
            throw exIO;
        }
        if (exXML != null) {
            throw exXML;
        }
        return doc;
    }

    public static void write(Document a_doc, OutputStream a_outputStream) throws IOException {
        XMLUtil.formatHumanReadable(a_doc);
        a_outputStream.write(XMLUtil.toString(a_doc).getBytes("UTF8"));
        a_outputStream.flush();
    }

    public static void write(Document a_doc, Writer a_writer) throws IOException {
        XMLUtil.formatHumanReadable(a_doc);
        a_writer.write(XMLUtil.toString(a_doc));
        a_writer.flush();
    }

    public static void write(Document a_doc, File a_file) throws IOException {
        FileOutputStream out = new FileOutputStream(a_file);
        XMLUtil.write(a_doc, out);
        out.close();
    }

    public static Document toXMLDocument(String a_xmlDocument) throws XMLParseException {
        if (a_xmlDocument == null) {
            return XMLUtil.toXMLDocument((byte[])null);
        }
        InputSource is = new InputSource(new StringReader(a_xmlDocument));
        try {
            return XMLUtil.readXMLDocument(is);
        }
        catch (XMLParseException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new XMLParseException("##__root__##", "Could not parse XML document: " + ex.getMessage());
        }
    }

    public static Document toXMLDocument(char[] a_xmlDocument) throws XMLParseException {
        return XMLUtil.toXMLDocument(new String(a_xmlDocument));
    }

    public static Document toXMLDocument(byte[] a_xmlDocument) throws XMLParseException {
        Document doc;
        ByteArrayInputStream in = new ByteArrayInputStream(a_xmlDocument);
        InputSource is = new InputSource(in);
        try {
            doc = XMLUtil.readXMLDocument(is);
        }
        catch (XMLParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XMLParseException("##__root__##", "Could not parse XML document: " + ex.getMessage());
        }
        return doc;
    }

    public static Document toXMLDocument(IXMLEncodable a_xmlEncodable) {
        Document doc = null;
        try {
            Element element = XMLUtil.toXMLElement(a_xmlEncodable);
            doc = element.getOwnerDocument();
            doc.appendChild(element);
        }
        catch (Throwable t) {
            return null;
        }
        return doc;
    }

    public static Document toSignedXMLDocument(IXMLEncodable a_xmlEncodable, int a_iDocumentClass) {
        Document doc = XMLUtil.toXMLDocument(a_xmlEncodable);
        SignatureCreator.getInstance().signXml(a_iDocumentClass, doc);
        return doc;
    }

    public static Element toXMLElement(IXMLEncodable a_xmlEncodable) {
        Document doc = XMLUtil.createDocument();
        if (doc == null) {
            return null;
        }
        Element element = a_xmlEncodable.toXmlElement(doc);
        return element;
    }

    public static final byte[] createDocumentStructure() {
        try {
            return XMLUtil.toByteArrayOutputStream(XMLUtil.createDocument()).toByteArray();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static ByteArrayOutputStream toByteArrayOutputStream(Node node) {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
        }
        catch (Throwable t3) {
            return null;
        }
        try {
            Class<?> c = Class.forName("com.sun.xml.tree.ParentNode");
            if (c.isInstance(node)) {
                Document doc = null;
                doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF8");
                Class<?> classXmlDocument = Class.forName("com.sun.xml.tree.XmlDocument");
                Class[] paramClasses = new Class[]{class$java$io$Writer == null ? (class$java$io$Writer = XMLUtil.class$("java.io.Writer")) : class$java$io$Writer, Integer.TYPE};
                Method methodCreateWriteContext = classXmlDocument.getMethod("createWriteContext", paramClasses);
                Object[] params = new Object[]{w, new Integer(2)};
                Object context = methodCreateWriteContext.invoke((Object)doc, params);
                paramClasses = new Class[]{Class.forName("com.sun.xml.tree.XmlWriteContext")};
                Method methodWriteXml = node.getClass().getMethod("writeXml", paramClasses);
                params = new Object[]{context};
                methodWriteXml.invoke((Object)node, params);
                ((Writer)w).flush();
                return out;
            }
        }
        catch (Throwable t1) {
            // empty catch block
        }
        try {
            Class<?>[] params;
            Class<?> transformerFactory = Class.forName("javax.xml.transform.TransformerFactory");
            Object transformerFactoryInstance = transformerFactory.getMethod("newInstance", null).invoke(transformerFactory, (Object[])null);
            Object transformer = transformerFactory.getMethod("newTransformer", null).invoke(transformerFactoryInstance, (Object[])null);
            Class<?> result = Class.forName("javax.xml.transform.stream.StreamResult");
            Object r = result.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = XMLUtil.class$("java.io.OutputStream")) : class$java$io$OutputStream).newInstance(out);
            Class<?> source = Class.forName("javax.xml.transform.dom.DOMSource");
            Object s = source.getConstructor(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XMLUtil.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).newInstance(node);
            Class<?> c = Class.forName("javax.xml.transform.Transformer");
            Method m = null;
            Method[] ms = c.getMethods();
            for (int i = 0; !(i >= ms.length || ms[i].getName().equals("transform") && (params = (m = ms[i]).getParameterTypes()).length == 2); ++i) {
            }
            Object[] p = new Object[]{s, r};
            m.invoke(transformer, p);
            return out;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    private static Node getFirstChildByNameUsingDeepSearchInternal(Node node, String name) {
        block5: {
            try {
                if (node.getNodeName().equals(name)) {
                    return node;
                }
                if (node.hasChildNodes()) {
                    NodeList childNodes = node.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node tmp_result = XMLUtil.getFirstChildByNameUsingDeepSearchInternal(childNodes.item(i), name);
                        if (tmp_result == null) continue;
                        return tmp_result;
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static int formatHumanReadable(Node a_element, int a_level) {
        int i;
        int added = 0;
        if (!m_bCheckedHumanReadableFormatting) {
            Document doc = XMLUtil.createDocument();
            Element test = doc.createElement("test1");
            doc.appendChild(test);
            test.appendChild(doc.createElement("test2"));
            test.appendChild(doc.createElement("test3"));
            StringTokenizer tokenizer = new StringTokenizer(XMLUtil.toString(test), "\n");
            int lines = 0;
            while (tokenizer.hasMoreTokens()) {
                ++lines;
                tokenizer.nextToken();
            }
            if (lines == 4) {
                m_bNeedsHumanReadableFormatting = false;
            }
            m_bCheckedHumanReadableFormatting = true;
        }
        if (!m_bNeedsHumanReadableFormatting) {
            return 0;
        }
        if (a_element.getNodeType() == 1 && XMLUtil.parseAttribute(a_element, "xml:space", "").equals("preserve")) {
            return 0;
        }
        if (a_element.hasChildNodes()) {
            NodeList childNodes = a_element.getChildNodes();
            for (i = 0; i < childNodes.getLength(); ++i) {
                i += XMLUtil.formatHumanReadable(childNodes.item(i), a_level + 1);
            }
        }
        if (a_element.getNodeType() == 3) {
            String content = a_element.getNodeValue();
            for (i = 0; i < SPECIAL_CHARS.length; ++i) {
                content = Util.replaceAll(content, SPECIAL_CHARS[i], ENTITIES[i], (String[])(SPECIAL_CHARS[i].equals("&") ? ENTITIES : null));
            }
            a_element.setNodeValue(content);
        }
        if (a_element.getNodeType() == 3 && (a_element.getNodeValue() == null || a_element.getNodeValue().trim().length() == 0 && a_element.getNodeValue().indexOf(10) == -1)) {
            if (XMLUtil.getNextSibling(a_element) == null && (a_element.getPreviousSibling() == null || a_element.getPreviousSibling().getNodeType() != 3 || a_element.getPreviousSibling().getNodeValue().indexOf(10) == -1)) {
                String space = new String();
                for (int i2 = 0; i2 < a_level - 1; ++i2) {
                    space = space + DEFAULT_FORMAT_SPACE;
                }
                Text newLine = a_element.getOwnerDocument().createTextNode(space);
                a_element.getParentNode().appendChild(newLine);
                added = 0;
            } else {
                added = -1;
            }
            a_element.getParentNode().removeChild(a_element);
            return added;
        }
        if (a_element.getOwnerDocument().getDocumentElement() != a_element && a_element.getNodeType() != 3) {
            Text newLine;
            Node node = XMLUtil.getNextSibling(a_element);
            StringBuffer spaceBuffer = new StringBuffer();
            for (i = 0; i < a_level; ++i) {
                spaceBuffer.append(DEFAULT_FORMAT_SPACE);
            }
            String space = spaceBuffer.toString();
            if (a_element == a_element.getParentNode().getFirstChild()) {
                newLine = a_element.getOwnerDocument().createTextNode("\n" + space);
                a_element.getParentNode().insertBefore(newLine, a_element);
                ++added;
            }
            if ((node = XMLUtil.getNextSibling(a_element)) != null && node.getNodeType() != 3) {
                newLine = a_element.getOwnerDocument().createTextNode("\n" + space);
                a_element.getParentNode().insertBefore(newLine, node);
                ++added;
            } else if (node == null) {
                space = space.substring(0, space.length() - DEFAULT_FORMAT_SPACE.length());
                newLine = a_element.getOwnerDocument().createTextNode("\n" + space);
                a_element.getParentNode().appendChild(newLine);
                ++added;
            }
        }
        return added;
    }

    private static int removeCommentsInternal(Node a_node, Node a_parentNode) {
        if (a_node.getNodeType() == 1 && XMLUtil.parseAttribute(a_node, "xml:space", "").equals("preserve")) {
            return 0;
        }
        if (a_node.getNodeType() == 8) {
            a_parentNode.removeChild(a_node);
            return 1;
        }
        if (a_node.getNodeType() == 3 && a_node.getNodeValue().trim().length() == 0) {
            a_parentNode.removeChild(a_node);
            return 1;
        }
        if (a_node.hasChildNodes()) {
            NodeList childNodes = a_node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                i -= XMLUtil.removeCommentsInternal(childNodes.item(i), a_node);
            }
        }
        return 0;
    }

    public static String stripNewlineFromHash(String hashValue) {
        int SHA1_LENGTH = 27;
        String lastTwoChars = hashValue.substring(28);
        if (hashValue.length() == 29 && lastTwoChars.equals("\n")) {
            hashValue = hashValue.substring(0, 28);
        }
        return hashValue;
    }

    public static String toString(IXMLEncodable xmlobject) {
        return XMLUtil.toString(XMLUtil.toXMLElement(xmlobject));
    }

    public static void printXmlEncodable(IXMLEncodable xmlobject) {
        System.out.println(XMLUtil.toString(xmlobject));
    }

    public static BigInteger parseValue(Element elem, BigInteger defValue) {
        try {
            String s = XMLUtil.parseValue((Node)elem, (String)null);
            if (s == null) {
                return defValue;
            }
            return new BigInteger(s.trim());
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static void setValue(Element elem, BigInteger i) {
        try {
            XMLUtil.setValue((Node)elem, i.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Document createDocumentFromElement(Element a_elem) throws XMLParseException {
        Document d = XMLUtil.createDocument();
        Node node = XMLUtil.importNode(d, a_elem, true);
        d.appendChild(node);
        return d;
    }

    public static String filterXMLChars(String a_source) {
        if (a_source == null) {
            return null;
        }
        String returnString = Util.replaceAll(a_source, "&", "&#38;");
        returnString = Util.replaceAll(returnString, "<", "&#60;");
        returnString = Util.replaceAll(returnString, ">", "&#62;");
        returnString = Util.replaceAll(returnString, "\"", "&#34;");
        return returnString;
    }

    public static void filterXMLCharsForAnObject(Object anObject) {
        if (anObject == null) {
            return;
        }
        Class<?> objectClass = anObject.getClass();
        Method[] allMethods = objectClass.getMethods();
        Method currentStringSetter = null;
        Method currentStringGetter = null;
        int currentModifiers = 0;
        String temp = null;
        String toFilter = null;
        for (int i = 0; i < allMethods.length; ++i) {
            if (allMethods[i].getParameterTypes().length != 1) continue;
            currentModifiers = allMethods[i].getModifiers();
            if (!allMethods[i].getParameterTypes()[0].equals(class$java$lang$String == null ? XMLUtil.class$("java.lang.String") : class$java$lang$String) || !allMethods[i].getName().startsWith("set") || !Modifier.isPublic(currentModifiers) || Modifier.isStatic(currentModifiers)) continue;
            currentStringGetter = null;
            toFilter = null;
            currentStringSetter = allMethods[i];
            temp = currentStringSetter.getName().substring(3);
            if (temp == null || temp.equals("")) continue;
            try {
                currentStringGetter = objectClass.getMethod("get" + temp, null);
                if (currentStringGetter == null || !currentStringGetter.getReturnType().equals(class$java$lang$String == null ? XMLUtil.class$("java.lang.String") : class$java$lang$String) || (toFilter = (String)currentStringGetter.invoke(anObject, (Object[])null)) == null) continue;
                toFilter = XMLUtil.filterXMLChars(toFilter);
                currentStringSetter.invoke(anObject, toFilter);
                continue;
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    public static String restoreFilteredXMLChars(String a_source) {
        if (a_source == null) {
            return null;
        }
        String returnString = Util.replaceAll(a_source, "&#38;", "&");
        returnString = Util.replaceAll(returnString, "&#60;", "<");
        returnString = Util.replaceAll(returnString, "&#62;", ">");
        returnString = Util.replaceAll(returnString, "&#34;", "\"");
        return returnString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        m_bCheckedHumanReadableFormatting = false;
        m_bNeedsHumanReadableFormatting = true;
        ms_storageMode = 0;
        SPECIAL_CHARS = new String[]{"&", "<", ">"};
        ENTITIES = new String[]{"&amp;", "&lt;", "&gt;"};
        if (ms_DocumentBuilderFactory == null) {
            try {
                ms_DocumentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

