/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.crypto.CertPath;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.crypto.MyECPublicKey;
import anon.crypto.MyRSAPublicKey;
import anon.crypto.MyX509Extensions;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509UnknownExtension;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPHtmlMultiLineLabel;
import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import logging.LogHolder;
import logging.LogType;

public class CertDetailsDialog
extends JAPDialog
implements MouseListener {
    private static final String CLASS_NAME = (class$gui$CertDetailsDialog == null ? (class$gui$CertDetailsDialog = CertDetailsDialog.class$("gui.CertDetailsDialog")) : class$gui$CertDetailsDialog).getName();
    public static final String MSG_CERTVALID = CLASS_NAME + "_certValid";
    public static final String MSG_CERTNOTVALID = CLASS_NAME + "_certNotValid";
    public static final String MSG_CERT_VERIFIED = CLASS_NAME + "_certVerified";
    public static final String MSG_CERT_NOT_VERIFIED = CLASS_NAME + "_certNotVerified";
    private static final String MSG_TITLE = CLASS_NAME;
    private static final String MSG_X509Attribute_ST = CLASS_NAME + "_attributeST";
    private static final String MSG_X509Attribute_L = CLASS_NAME + "_attributeL";
    private static final String MSG_X509Attribute_C = CLASS_NAME + "_attributeC";
    private static final String MSG_X509Attribute_CN = CLASS_NAME + "_attributeCN";
    private static final String MSG_X509Attribute_O = CLASS_NAME + "_attributeO";
    private static final String MSG_X509Attribute_OU = CLASS_NAME + "_attributeOU";
    private static final String MSG_X509Attribute_EMAIL = CLASS_NAME + "_attributeEMAIL";
    private static final String MSG_SHOW_CERT = CLASS_NAME + "_showCert";
    private static final String MSG_CERT_HIERARCHY = CLASS_NAME + "_certHierarchy";
    private static final String MSG_SYMBOLS = CLASS_NAME + "_symbols";
    private static final String MSG_DETAILS = CLASS_NAME + "_detailsTab";
    private static final String MSG_X509Attribute_EMAILADDRESS = CLASS_NAME + "_attributeEMAIL";
    private static final String MSG_X509Attribute_SURNAME = CLASS_NAME + "_attributeSURNAME";
    private static final String MSG_X509Attribute_GIVENNAME = CLASS_NAME + "_attributeGIVENNAME";
    private static final String MSG_ALERT_CERTDATE_EXPIRED = CLASS_NAME + "_alertCertValidityExpired";
    private static final String MSG_ALERT_CERTDATE_NOTYET = CLASS_NAME + "_alertCertNotYetValid";
    private static final String MSG_ALERT_SELF_SIGNED = CLASS_NAME + "_alertSelfSigned";
    private static final String MSG_ALERT_NOT_TRUSTED = CLASS_NAME + "_alertSignatureNotTrusted";
    private static final String UNKNOWN_EXTENSION = CLASS_NAME + "_alertUnknownExtension";
    private static final String TITLE_DISTINGUISHEDNAME = CLASS_NAME + "_titleDistinguishedName";
    private static final String TITLE_ISSUER = CLASS_NAME + "_titleIssuer";
    private static final String TITLE_VALIDITY = CLASS_NAME + "_titleValidity";
    private static final String TITLE_VALIDITY_GENERAL = CLASS_NAME + "_titleValidityGeneral";
    private static final String TITLE_VALIDITY_TO = CLASS_NAME + "_titleValidityTo";
    private static final String TITLE_VALIDITY_FROM = CLASS_NAME + "_titleValidityFrom";
    private static final String TITLE_EXTENSIONS = CLASS_NAME + "_titleExtensions";
    private static final String TITLE_IDENTIFICATION = CLASS_NAME + "_titleIdentification";
    private static final String TITLE_IDENTIFICATION_SHA1 = CLASS_NAME + "_titleIdentificationSHA1";
    private static final String TITLE_IDENTIFICATION_MD5 = CLASS_NAME + "_titleIdentificationMD5";
    private static final String TITLE_IDENTIFICATION_SKEIN = CLASS_NAME + "_titleIdentificationSKEIN";
    private static final String TITLE_IDENTIFICATION_SERIAL = CLASS_NAME + "_titleIdentificationSerial";
    private static final String TITLE_KEYS = CLASS_NAME + "_titleKeys";
    private static final String TITLE_KEYS_ALGORITHM = CLASS_NAME + "_titleKeysAlgorithm";
    private static final String TITLE_KEYS_KEYLENGTH = CLASS_NAME + "_titleKeysKeylength";
    private static final String TITLE_KEYS_SIGNALGORITHM = CLASS_NAME + "_titleKeysSignatureAlgorithm";
    private static final String MSG_CERT_INFO_BORDER = CLASS_NAME + "_certInfoBorder";
    private static final String CERT_VALID_INACTIVE = "certinactive.gif";
    private static final String CERT_INVALID_INACTIVE = "certinvalidinactive.gif";
    private final JLabel LABEL = new JLabel();
    private final Color TITLE_COLOR = Color.blue;
    private final Color ALERT_COLOR = Color.red;
    private final Font TITLE_FONT = new Font(this.LABEL.getFont().getName(), 1, (int)((double)this.LABEL.getFont().getSize() * 1.2));
    private final Font KEY_FONT = new Font(this.LABEL.getFont().getName(), 1, this.LABEL.getFont().getSize());
    private final Font VALUE_FONT = new Font(this.LABEL.getFont().getName(), 0, this.LABEL.getFont().getSize());
    private final Font ALERT_FONT = new Font(this.LABEL.getFont().getName(), 1, this.LABEL.getFont().getSize());
    public static final String IMG_CERTENABLEDICON = "cenabled.gif";
    public static final String IMG_CERTDISABLEDICON = "cdisabled.gif";
    public static final String IMG_WARNING = "warning.gif";
    private static final String IMG_PATH = "certs/";
    private static final String IMG_CERT_ORANGE_OK = "certs/cert_orange_ok.png";
    private static final String IMG_CERT_ORANGE_NOK = "certs/cert_orange_nok.png";
    private static final String IMG_CERT_ORANGE_INVALID = "certs/cert_orange_invalid.png";
    private static final String IMG_CERT_ORANGE_OK_DARK = "certs/cert_orange_ok_dark.png";
    private static final String IMG_CERT_ORANGE_NOK_DARK = "certs/cert_orange_nok_dark.png";
    private static final String IMG_CERT_ORANGE_INVALID_DARK = "certs/cert_orange_invalid_dark.png";
    private static final String IMG_CERT_PURPLE_OK = "certs/cert_purple_ok.png";
    private static final String IMG_CERT_PURPLE_NOK = "certs/cert_purple_nok.png";
    private static final String IMG_CERT_PURPLE_INVALID = "certs/cert_purple_invalid.png";
    private static final String IMG_CERT_PURPLE_OK_DARK = "certs/cert_purple_ok_dark.png";
    private static final String IMG_CERT_PURPLE_NOK_DARK = "certs/cert_purple_nok_dark.png";
    private static final String IMG_CERT_PURPLE_INVALID_DARK = "certs/cert_purple_invalid_dark.png";
    private static final String IMG_CERT_BLUE_OK = "certs/cert_blue_ok.png";
    private static final String IMG_CERT_BLUE_NOK = "certs/cert_blue_nok.png";
    private static final String IMG_CERT_BLUE_INVALID = "certs/cert_blue_invalid.png";
    private static final String IMG_CERT_BLUE_OK_DARK = "certs/cert_blue_ok_dark.png";
    private static final String IMG_CERT_BLUE_NOK_DARK = "certs/cert_blue_nok_dark.png";
    private static final String IMG_CERT_BLUE_INVALID_DARK = "certs/cert_orange_invalid_dark.png";
    private JLabel lbl_summaryIcon;
    private Locale m_Locale;
    private String str;
    private CertShortInfoPanel m_shortInfoPanel;
    private JList m_certList;
    private JTabbedPane m_tabbedPane;
    private DefaultListModel m_certListModel;
    private JAPCertificate m_detailedCert;
    static /* synthetic */ Class class$gui$CertDetailsDialog;

    public CertDetailsDialog(Component a_parent, JAPCertificate a_cert, boolean a_bIsVerifyable, Locale a_locale, CertPath a_certPath) {
        super(a_parent, JAPMessages.getString(MSG_TITLE));
        this.m_Locale = a_locale;
        JTabbedPane tabbedPane = new JTabbedPane();
        TitledGridBagPanel detailsPanel = this.drawDetailsPanel(a_cert, a_bIsVerifyable);
        JPanel certPathPanel = this.drawCertPathPanel(a_certPath);
        tabbedPane.add(JAPMessages.getString(MSG_DETAILS), detailsPanel);
        tabbedPane.add(JAPMessages.getString(MSG_CERT_HIERARCHY), certPathPanel);
        JScrollPane sp = new JScrollPane(tabbedPane, 20, 30);
        this.getContentPane().add(sp);
        this.m_tabbedPane = tabbedPane;
        this.m_detailedCert = a_cert;
        this.setSize();
        this.getContentPane().setVisible(true);
    }

    public CertDetailsDialog(Component a_parent, JAPCertificate a_cert, boolean a_bIsVerifyable, Locale a_locale) {
        super(a_parent, JAPMessages.getString(MSG_TITLE));
        this.m_Locale = a_locale;
        TitledGridBagPanel detailsPanel = this.drawDetailsPanel(a_cert, a_bIsVerifyable);
        JScrollPane sp = new JScrollPane(detailsPanel, 20, 30);
        this.getContentPane().add(sp);
        this.setSize();
        this.setVisible(true);
    }

    private void setSize() {
        this.pack();
        if (this.getSize().height > 480) {
            this.setSize(this.getSize().width, 480);
        }
        if (this.getSize().width > 640) {
            this.setSize(640, this.getSize().height);
        }
    }

    private Vector idsToNames(Vector a_vector) {
        Vector<String> res = new Vector<String>(a_vector.size());
        String str = " ";
        if (a_vector != null && a_vector.size() > 0) {
            for (int i = 0; i < a_vector.size(); ++i) {
                String abbrev = X509DistinguishedName.getAttributeNameFromAttributeIdentifier((String)a_vector.elementAt(i));
                str = abbrev.equals("ST") ? JAPMessages.getString(MSG_X509Attribute_ST) : (abbrev.equals("L") ? JAPMessages.getString(MSG_X509Attribute_L) : (abbrev.equals("C") ? JAPMessages.getString(MSG_X509Attribute_C) : (abbrev.equals("CN") ? JAPMessages.getString(MSG_X509Attribute_CN) : (abbrev.equals("O") ? JAPMessages.getString(MSG_X509Attribute_O) : (abbrev.equals("OU") ? JAPMessages.getString(MSG_X509Attribute_OU) : (abbrev.equals("E") ? JAPMessages.getString(MSG_X509Attribute_EMAIL) : (abbrev.equals("EmailAddress") ? JAPMessages.getString(MSG_X509Attribute_EMAILADDRESS) : (abbrev.equals("SURNAME") ? JAPMessages.getString(MSG_X509Attribute_SURNAME) : (abbrev.equals("GIVENNAME") ? JAPMessages.getString(MSG_X509Attribute_GIVENNAME) : abbrev)))))))));
                if (!str.equals(abbrev)) {
                    str = str + " (" + abbrev + ")";
                }
                res.addElement(str);
            }
        }
        return res;
    }

    private TitledGridBagPanel drawDetailsPanel(JAPCertificate a_cert, boolean a_bIsVerifyable) {
        JLabel lbl_val;
        JLabel lbl_key;
        String MSG;
        Insets inset = new Insets(2, 5, 2, 5);
        TitledGridBagPanel detailsPanel = new TitledGridBagPanel(null, inset);
        detailsPanel.addMouseListener(this);
        this.lbl_summaryIcon = new JLabel();
        if (a_cert.getPublicKey() instanceof MyRSAPublicKey) {
            if (a_bIsVerifyable) {
                if (a_cert.getValidity().isValid(new Date())) {
                    this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_OK, true, false));
                } else {
                    this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_INVALID, true, false));
                }
            } else {
                this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_NOK, true, false));
            }
        } else if (a_cert.getPublicKey() instanceof MyECPublicKey) {
            if (a_bIsVerifyable) {
                if (a_cert.getValidity().isValid(new Date())) {
                    this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_OK, true, false));
                } else {
                    this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_INVALID, true, false));
                }
            } else {
                this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_NOK, true, false));
            }
        } else if (a_bIsVerifyable) {
            if (a_cert.getValidity().isValid(new Date())) {
                this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_OK, true, false));
            } else {
                this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_INVALID, true, false));
            }
        } else {
            this.lbl_summaryIcon.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_NOK, true, false));
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.anchor = 13;
        constraints.gridheight = 3;
        constraints.insets = new Insets(1, 10, 1, 10);
        detailsPanel.add((Component)this.lbl_summaryIcon, constraints);
        constraints.anchor = 17;
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.insets = inset;
        JLabel lbl_summaryName = new JLabel(a_cert.getSubject().getCommonName(), 2);
        lbl_summaryName.setForeground(this.TITLE_COLOR);
        lbl_summaryName.setFont(this.TITLE_FONT);
        constraints.gridwidth = 2;
        detailsPanel.add((Component)lbl_summaryName, constraints);
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        detailsPanel.add((Component)new JLabel(JAPMessages.getString(TITLE_ISSUER), 4), constraints);
        constraints.gridx = 2;
        this.str = a_cert.getIssuer().getOrganisation();
        if (this.str == null || this.str.equals("")) {
            this.str = a_cert.getIssuer().getCommonName();
        }
        detailsPanel.add((Component)new JLabel(this.str), constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        detailsPanel.add((Component)new JLabel(JAPMessages.getString(TITLE_VALIDITY_TO), 4), constraints);
        constraints.gridx = 2;
        detailsPanel.add((Component)new JLabel(a_cert.getValidity().getValidTo().toString()), constraints);
        detailsPanel.addDummyRows(5);
        Date today = new Date();
        if (!a_cert.getValidity().isValid(today)) {
            JLabel lbl_validityAlert;
            if (a_cert.getValidity().getValidFrom().getTime() < today.getTime()) {
                MSG = JAPMessages.getString(MSG_ALERT_CERTDATE_EXPIRED);
                lbl_validityAlert = new JLabel(MSG, 2);
                lbl_validityAlert.setFont(this.ALERT_FONT);
                lbl_validityAlert.setForeground(this.ALERT_COLOR);
                detailsPanel.addRow(null, null, lbl_validityAlert, null);
            } else if (a_cert.getValidity().getValidTo().getTime() > today.getTime()) {
                MSG = JAPMessages.getString(MSG_ALERT_CERTDATE_NOTYET);
                lbl_validityAlert = new JLabel(MSG, 2);
                lbl_validityAlert.setFont(this.ALERT_FONT);
                lbl_validityAlert.setForeground(this.ALERT_COLOR);
                detailsPanel.addRow(null, null, lbl_validityAlert, null);
            }
        }
        if (!a_bIsVerifyable) {
            MSG = JAPMessages.getString(MSG_ALERT_NOT_TRUSTED);
            if (a_cert.verify(a_cert)) {
                MSG = JAPMessages.getString(MSG_ALERT_SELF_SIGNED);
            }
            JLabel lbl_verifyAlert = new JLabel(MSG, 2);
            lbl_verifyAlert.setFont(this.ALERT_FONT);
            lbl_verifyAlert.setForeground(this.ALERT_COLOR);
            detailsPanel.addRow(null, null, lbl_verifyAlert, null);
        }
        X509DistinguishedName dName = a_cert.getSubject();
        Vector distinguishedNameKeys = dName.getAttributeIdentifiers();
        Vector distinguishedNameValues = dName.getAttributeValues();
        this.replaceCountryCodeByCountryName(distinguishedNameValues, distinguishedNameKeys);
        distinguishedNameKeys = this.idsToNames(distinguishedNameKeys);
        JLabel title_dName = new JLabel(JAPMessages.getString(TITLE_DISTINGUISHEDNAME), 4);
        title_dName.setFont(this.TITLE_FONT);
        title_dName.setForeground(this.TITLE_COLOR);
        detailsPanel.addRow((Component)title_dName, null, new JSeparator(0));
        for (int i = 0; i < distinguishedNameKeys.size(); ++i) {
            lbl_key = new JLabel(distinguishedNameKeys.elementAt(i).toString(), 4);
            lbl_key.setFont(this.KEY_FONT);
            lbl_val = new JLabel(distinguishedNameValues.elementAt(i).toString(), 2);
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
        }
        Vector issuerKeys = a_cert.getIssuer().getAttributeIdentifiers();
        Vector issuerValues = a_cert.getIssuer().getAttributeValues();
        this.replaceCountryCodeByCountryName(issuerValues, issuerKeys);
        issuerKeys = this.idsToNames(issuerKeys);
        JLabel title_Issuer = new JLabel(JAPMessages.getString(TITLE_ISSUER), 4);
        title_Issuer.setFont(this.TITLE_FONT);
        title_Issuer.setForeground(this.TITLE_COLOR);
        detailsPanel.addRow((Component)title_Issuer, null, new JSeparator(0));
        for (int i = 0; i < issuerKeys.size(); ++i) {
            lbl_key = new JLabel(issuerKeys.elementAt(i).toString(), 4);
            lbl_key.setFont(this.KEY_FONT);
            lbl_val = new JLabel(issuerValues.elementAt(i).toString(), 2);
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
        }
        MyX509Extensions extensionsVect = a_cert.getExtensions();
        JLabel title_extensions = new JLabel(JAPMessages.getString(TITLE_EXTENSIONS), 4);
        title_extensions.setFont(this.TITLE_FONT);
        title_extensions.setForeground(this.TITLE_COLOR);
        if (extensionsVect.getSize() > 0) {
            detailsPanel.addRow((Component)title_extensions, null, new JSeparator(0));
        }
        String critical = null;
        for (int i = 0; i < extensionsVect.getExtensions().size(); ++i) {
            int j;
            if (extensionsVect.getExtension(i) instanceof X509UnknownExtension) {
                critical = extensionsVect.getExtension(i).isCritical() ? "*" : "";
                lbl_key = new JLabel(JAPMessages.getString(UNKNOWN_EXTENSION) + critical, 4);
                lbl_key.setFont(this.KEY_FONT);
                StringBuffer sb = new StringBuffer();
                for (j = 0; j < extensionsVect.getExtension(i).getValues().size(); ++j) {
                    sb.append(extensionsVect.getExtension(i).getIdentifier());
                }
                lbl_val = new JLabel(sb.toString(), 2);
                lbl_key.setFont(this.KEY_FONT);
                lbl_val.setFont(this.VALUE_FONT);
                detailsPanel.addRow((Component)lbl_key, null, lbl_val);
                continue;
            }
            lbl_key = new JLabel(extensionsVect.getExtension(i).getName(), 4);
            lbl_key.setFont(this.KEY_FONT);
            Vector values = extensionsVect.getExtension(i).getValues();
            if (values.size() == 0) {
                detailsPanel.addRow((Component)lbl_key, null, null);
                continue;
            }
            lbl_val = new JLabel(values.elementAt(0).toString());
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
            for (j = 1; j < values.size(); ++j) {
                lbl_val = new JLabel(values.elementAt(j).toString());
                lbl_val.setFont(this.VALUE_FONT);
                detailsPanel.addRow(null, null, lbl_val);
            }
        }
        Validity validity = a_cert.getValidity();
        Vector<String> validityKeys = new Vector<String>();
        validityKeys.addElement(new String(JAPMessages.getString(TITLE_VALIDITY_GENERAL)));
        validityKeys.addElement(new String(JAPMessages.getString(TITLE_VALIDITY_FROM)));
        validityKeys.addElement(new String(JAPMessages.getString(TITLE_VALIDITY_TO)));
        Vector<String> validityValues = new Vector<String>();
        if (validity.isValid(new Date())) {
            validityValues.addElement(JAPMessages.getString(MSG_CERTVALID));
        } else {
            validityValues.addElement(JAPMessages.getString(MSG_CERTNOTVALID));
        }
        validityValues.addElement(validity.getValidFrom().toString());
        validityValues.addElement(validity.getValidTo().toString());
        JLabel title_validity = new JLabel(JAPMessages.getString(TITLE_VALIDITY), 4);
        title_validity.setFont(this.TITLE_FONT);
        title_validity.setForeground(this.TITLE_COLOR);
        detailsPanel.addRow((Component)title_validity, null, new JSeparator(0));
        for (int i = 0; i < validityKeys.size(); ++i) {
            lbl_key = new JLabel(validityKeys.elementAt(i).toString(), 4);
            lbl_val = new JLabel(validityValues.elementAt(i).toString(), 2);
            lbl_key.setFont(this.KEY_FONT);
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
        }
        Vector<String> fpKeys = new Vector<String>();
        fpKeys.addElement(JAPMessages.getString(TITLE_IDENTIFICATION_SHA1));
        fpKeys.addElement(JAPMessages.getString(TITLE_IDENTIFICATION_MD5));
        fpKeys.addElement(JAPMessages.getString(TITLE_IDENTIFICATION_SKEIN));
        fpKeys.addElement(JAPMessages.getString(TITLE_IDENTIFICATION_SERIAL));
        Vector<Object> fpValues = new Vector<Object>();
        fpValues.addElement(a_cert.getSHA1Fingerprint());
        fpValues.addElement(a_cert.getMD5Fingerprint());
        fpValues.addElement(a_cert.getSKEINFingerprint());
        fpValues.addElement(a_cert.getSerialNumber());
        JLabel title_fingerprints = new JLabel(JAPMessages.getString(TITLE_IDENTIFICATION), 4);
        title_fingerprints.setFont(this.TITLE_FONT);
        title_fingerprints.setForeground(this.TITLE_COLOR);
        detailsPanel.addRow((Component)title_fingerprints, null, new JSeparator(0));
        for (int i = 0; i < fpKeys.size(); ++i) {
            lbl_key = new JLabel(fpKeys.elementAt(i).toString(), 4);
            lbl_val = new JLabel(fpValues.elementAt(i).toString());
            lbl_key.setFont(this.KEY_FONT);
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
        }
        Vector<String> keyKeys = new Vector<String>();
        keyKeys.addElement(JAPMessages.getString(TITLE_KEYS_ALGORITHM));
        Vector<String> keyValues = new Vector<String>();
        keyValues.addElement(new String(a_cert.getPublicKey().getAlgorithm()));
        int kLength = a_cert.getPublicKey().getKeyLength();
        keyKeys.addElement(JAPMessages.getString(TITLE_KEYS_KEYLENGTH));
        keyValues.addElement(new Integer(kLength).toString() + " Bit");
        keyKeys.addElement(JAPMessages.getString(TITLE_KEYS_SIGNALGORITHM));
        keyValues.addElement(a_cert.getSignatureAlgorithmName());
        JLabel title_keys = new JLabel(JAPMessages.getString(TITLE_KEYS), 4);
        title_keys.setFont(this.TITLE_FONT);
        title_keys.setForeground(this.TITLE_COLOR);
        detailsPanel.addRow((Component)title_keys, null, new JSeparator(0));
        for (int i = 0; i < keyKeys.size(); ++i) {
            lbl_key = new JLabel(keyKeys.elementAt(i).toString(), 4);
            lbl_val = new JLabel(keyValues.elementAt(i).toString());
            lbl_key.setFont(this.KEY_FONT);
            lbl_val.setFont(this.VALUE_FONT);
            detailsPanel.addRow((Component)lbl_key, null, lbl_val);
        }
        return detailsPanel;
    }

    private JPanel drawCertPathPanel(CertPath a_certPath) {
        JPanel certPathPanel = new JPanel();
        certPathPanel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 10, 5, 10);
        JLabel title_certPath = new JLabel(JAPMessages.getString(MSG_CERT_HIERARCHY), 4);
        title_certPath.setFont(this.TITLE_FONT);
        title_certPath.setForeground(this.TITLE_COLOR);
        certPathPanel.add((Component)title_certPath, constraints);
        this.m_certListModel = new DefaultListModel();
        this.m_certList = new JList(this.m_certListModel);
        this.m_certList.setFont(this.VALUE_FONT);
        this.m_certList.setSelectionMode(0);
        this.m_certList.setCellRenderer(new CertPathListCellRenderer());
        this.m_certList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (CertDetailsDialog.this.m_certListModel.getSize() != 0 && CertDetailsDialog.this.m_certList.getSelectedValue() != null) {
                    CertDetailsDialog.this.m_shortInfoPanel.update(((CertificateInfoStructure)CertDetailsDialog.this.m_certList.getSelectedValue()).getCertificate());
                }
            }
        });
        this.m_certList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent a_event) {
                if (a_event.getClickCount() == 2) {
                    CertDetailsDialog.this.showCert();
                }
            }
        });
        JScrollPane scrpaneList = new JScrollPane();
        scrpaneList.setHorizontalScrollBarPolicy(30);
        scrpaneList.setVerticalScrollBarPolicy(20);
        scrpaneList.getViewport().add(this.m_certList);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.gridheight = 5;
        constraints.weightx = 3.0;
        constraints.weighty = 2.0;
        constraints.insets = new Insets(5, 20, 10, 20);
        constraints.fill = 1;
        constraints.anchor = 11;
        certPathPanel.add((Component)scrpaneList, constraints);
        JButton view = new JButton(JAPMessages.getString(MSG_SHOW_CERT) + "...");
        view.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CertDetailsDialog.this.showCert();
            }
        });
        ++constraints.gridx;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(10, 5, 10, 20);
        constraints.fill = 0;
        constraints.anchor = 18;
        certPathPanel.add((Component)view, constraints);
        ++constraints.gridy;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.anchor = 16;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        JAPHtmlMultiLineLabel lbl_symbols = new JAPHtmlMultiLineLabel(JAPMessages.getString(MSG_SYMBOLS));
        certPathPanel.add((Component)lbl_symbols, constraints);
        constraints.insets = new Insets(5, 15, 5, 5);
        ++constraints.gridy;
        JLabel lbl_verified = new JLabel(JAPMessages.getString(MSG_CERTVALID), GUIUtils.loadImageIcon(IMG_CERTENABLEDICON, false, false), 2);
        certPathPanel.add((Component)lbl_verified, constraints);
        ++constraints.gridy;
        JLabel lbl_invalid = new JLabel(JAPMessages.getString(MSG_CERTNOTVALID), GUIUtils.loadImageIcon(IMG_WARNING, false, false), 2);
        certPathPanel.add((Component)lbl_invalid, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(5, 15, 20, 5);
        JLabel lbl_unverified = new JLabel(JAPMessages.getString(MSG_CERT_NOT_VERIFIED), GUIUtils.loadImageIcon(IMG_CERTDISABLEDICON, false, false), 2);
        lbl_unverified.setForeground(Color.red);
        certPathPanel.add((Component)lbl_unverified, constraints);
        --constraints.gridx;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(10, 20, 10, 10);
        constraints.fill = 2;
        constraints.anchor = 11;
        certPathPanel.add((Component)new JSeparator(), constraints);
        this.m_shortInfoPanel = new CertShortInfoPanel();
        if (a_certPath != null && this.m_certListModel.getSize() > 0) {
            this.m_certList.setSelectedValue(this.m_certListModel.lastElement(), true);
        }
        ++constraints.gridy;
        constraints.weighty = 1.0;
        certPathPanel.add((Component)this.m_shortInfoPanel, constraints);
        return certPathPanel;
    }

    private void showCert() {
        boolean verified = true;
        if (this.m_shortInfoPanel.getShownCertificate() != null) {
            if (this.m_shortInfoPanel.getShownCertificate().equals(this.m_detailedCert)) {
                this.m_tabbedPane.setSelectedIndex(0);
            } else {
                if (this.m_certList.getSelectedIndex() == 0) {
                    verified = ((CertificateInfoStructure)this.m_certListModel.firstElement()).isEnabled();
                }
                CertDetailsDialog dialog = new CertDetailsDialog(this.getContentPane(), this.m_shortInfoPanel.getShownCertificate(), verified, this.m_Locale);
                dialog.setVisible(true);
            }
        }
    }

    private void replaceCountryCodeByCountryName(Vector a_attributes, Vector a_identifiers) {
        for (int i = 0; i < a_attributes.size(); ++i) {
            if (!a_identifiers.elementAt(i).equals(X509DistinguishedName.IDENTIFIER_C)) continue;
            try {
                a_attributes.setElementAt(new CountryMapper(a_attributes.elementAt(i).toString(), this.m_Locale).toString(), i);
                continue;
            }
            catch (IllegalArgumentException a_e) {
                LogHolder.log(7, LogType.GUI, "Invalid / Unknown country code");
                a_attributes.setElementAt(a_attributes.elementAt(i), i);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e != null && e.getClickCount() >= 2) {
            this.dispose();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class CertPathListCellRenderer
    implements ListCellRenderer {
        private int m_itemcount = 0;

        private CertPathListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int a_index, boolean isSelected, boolean cellHasFocus) {
            JPanel cell = new JPanel(new GridBagLayout());
            JLabel spaceLbl = new JLabel();
            JLabel certIconLabel = new JLabel();
            JLabel certTextLabel = new JLabel();
            JLabel fill = new JLabel();
            GridBagConstraints constraints = new GridBagConstraints();
            int spaces = a_index * 2;
            if (spaces > 0) {
                char[] space = new char[spaces];
                for (int i = 0; i < space.length; ++i) {
                    space[i] = 32;
                }
                spaceLbl.setText(new String(space));
            }
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            cell.add((Component)spaceLbl, constraints);
            ++constraints.gridx;
            cell.add((Component)certIconLabel, constraints);
            ++constraints.gridx;
            cell.add((Component)certTextLabel, constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            fill = new JLabel(" ");
            cell.add((Component)fill, constraints);
            ++this.m_itemcount;
            CertificateInfoStructure j = (CertificateInfoStructure)value;
            String subjectCN = j.getCertificate().getSubject().getCommonName();
            if (subjectCN == null) {
                subjectCN = j.getCertificate().getSubject().toString();
            }
            certTextLabel.setText(subjectCN);
            certTextLabel.setEnabled(list.isEnabled());
            certIconLabel.setEnabled(list.isEnabled());
            spaceLbl.setEnabled(list.isEnabled());
            fill.setEnabled(list.isEnabled());
            if (isSelected) {
                certTextLabel.setBackground(list.getSelectionBackground());
                certTextLabel.setForeground(list.getSelectionForeground());
                cell.setBackground(list.getSelectionBackground());
                cell.setForeground(list.getSelectionForeground());
                certIconLabel.setBackground(list.getSelectionBackground());
                certIconLabel.setForeground(list.getSelectionForeground());
                spaceLbl.setBackground(list.getSelectionBackground());
                spaceLbl.setForeground(list.getSelectionBackground());
                fill.setBackground(list.getSelectionBackground());
                fill.setForeground(list.getSelectionForeground());
            } else {
                certTextLabel.setBackground(list.getBackground());
                certTextLabel.setForeground(list.getForeground());
                cell.setBackground(list.getBackground());
                cell.setForeground(list.getForeground());
                certIconLabel.setBackground(list.getBackground());
                certIconLabel.setForeground(list.getForeground());
                spaceLbl.setBackground(list.getBackground());
                spaceLbl.setForeground(list.getBackground());
                fill.setBackground(list.getBackground());
                fill.setForeground(list.getForeground());
            }
            certTextLabel.setOpaque(isSelected);
            cell.setOpaque(isSelected);
            certIconLabel.setOpaque(isSelected);
            spaceLbl.setOpaque(isSelected);
            fill.setOpaque(isSelected);
            if (j.isEnabled()) {
                if (j.getCertificate().getValidity().isValid(new Date())) {
                    certIconLabel.setIcon(GUIUtils.loadImageIcon(CertDetailsDialog.IMG_CERTENABLEDICON, false, false));
                } else {
                    certIconLabel.setIcon(GUIUtils.loadImageIcon(CertDetailsDialog.IMG_WARNING, false, false));
                }
            } else {
                certTextLabel.setForeground(Color.red);
                certIconLabel.setIcon(GUIUtils.loadImageIcon(CertDetailsDialog.IMG_CERTDISABLEDICON, false, false));
            }
            if (j.equals(list.getModel().getElementAt(list.getModel().getSize() - 1))) {
                certTextLabel.setFont(new Font(certTextLabel.getFont().getName(), 1, certTextLabel.getFont().getSize()));
            } else {
                certTextLabel.setFont(list.getFont());
            }
            return cell;
        }
    }

    public static class CertShortInfoPanel
    extends JPanel {
        private JLabel m_labelDate;
        private JLabel m_labelCN;
        private JLabel m_labelE;
        private JLabel m_labelCSTL;
        private JLabel m_labelO;
        private JLabel m_labelOU;
        private JLabel m_labelDateData;
        private JLabel m_labelCNData;
        private JLabel m_labelEData;
        private JLabel m_labelCSTLData;
        private JLabel m_labelOData;
        private JLabel m_labelOUData;
        private JLabel m_lblCertTitle;
        private JAPCertificate m_selectedCert;

        public CertShortInfoPanel() {
            GridBagLayout panelLayoutInfo = new GridBagLayout();
            this.setLayout(panelLayoutInfo);
            GridBagConstraints panelConstraintsInfo = new GridBagConstraints();
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(0, 10, 0, 0);
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 0;
            panelConstraintsInfo.gridwidth = 2;
            this.m_lblCertTitle = new JLabel(JAPMessages.getString(MSG_CERT_INFO_BORDER));
            this.add((Component)this.m_lblCertTitle, panelConstraintsInfo);
            this.m_labelDate = new JLabel(JAPMessages.getString(TITLE_VALIDITY) + ":");
            this.m_labelCN = new JLabel(JAPMessages.getString(MSG_X509Attribute_CN) + ":");
            this.m_labelE = new JLabel(JAPMessages.getString(MSG_X509Attribute_EMAIL) + ":");
            this.m_labelCSTL = new JLabel(JAPMessages.getString(MSG_X509Attribute_L) + ":");
            this.m_labelO = new JLabel(JAPMessages.getString(MSG_X509Attribute_O) + ":");
            this.m_labelOU = new JLabel(JAPMessages.getString(MSG_X509Attribute_OU) + ":");
            this.m_labelDateData = new JLabel();
            this.m_labelCNData = new JLabel();
            this.m_labelEData = new JLabel();
            this.m_labelCSTLData = new JLabel();
            this.m_labelOData = new JLabel();
            this.m_labelOUData = new JLabel();
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.fill = 2;
            panelConstraintsInfo.gridwidth = 1;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 1;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
            panelLayoutInfo.setConstraints(this.m_labelCN, panelConstraintsInfo);
            this.add(this.m_labelCN);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 1;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
            panelLayoutInfo.setConstraints(this.m_labelCNData, panelConstraintsInfo);
            this.add(this.m_labelCNData);
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 2;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
            panelLayoutInfo.setConstraints(this.m_labelO, panelConstraintsInfo);
            this.add(this.m_labelO);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 2;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
            panelLayoutInfo.setConstraints(this.m_labelOData, panelConstraintsInfo);
            this.add(this.m_labelOData);
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 3;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
            panelLayoutInfo.setConstraints(this.m_labelOU, panelConstraintsInfo);
            this.add(this.m_labelOU);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 3;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
            panelLayoutInfo.setConstraints(this.m_labelOUData, panelConstraintsInfo);
            this.add(this.m_labelOUData);
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 4;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
            panelLayoutInfo.setConstraints(this.m_labelCSTL, panelConstraintsInfo);
            this.add(this.m_labelCSTL);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 4;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
            panelLayoutInfo.setConstraints(this.m_labelCSTLData, panelConstraintsInfo);
            this.add(this.m_labelCSTLData);
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 5;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
            panelLayoutInfo.setConstraints(this.m_labelE, panelConstraintsInfo);
            this.add(this.m_labelE);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 5;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
            panelLayoutInfo.setConstraints(this.m_labelEData, panelConstraintsInfo);
            this.add(this.m_labelEData);
            panelConstraintsInfo.anchor = 17;
            panelConstraintsInfo.gridx = 0;
            panelConstraintsInfo.gridy = 6;
            panelConstraintsInfo.fill = 2;
            panelConstraintsInfo.weightx = 0.0;
            panelConstraintsInfo.insets = new Insets(10, 15, 10, 0);
            panelLayoutInfo.setConstraints(this.m_labelDate, panelConstraintsInfo);
            this.add(this.m_labelDate);
            panelConstraintsInfo.gridx = 1;
            panelConstraintsInfo.gridy = 6;
            panelConstraintsInfo.weightx = 1.0;
            panelConstraintsInfo.insets = new Insets(10, 10, 10, 10);
            panelLayoutInfo.setConstraints(this.m_labelDateData, panelConstraintsInfo);
            this.add(this.m_labelDateData);
            panelConstraintsInfo.anchor = 17;
        }

        public JAPCertificate getShownCertificate() {
            return this.m_selectedCert;
        }

        public void setEnabled(boolean a_bEnable) {
            this.m_lblCertTitle.setEnabled(a_bEnable);
            this.m_labelDate.setEnabled(a_bEnable);
            this.m_labelCN.setEnabled(a_bEnable);
            this.m_labelE.setEnabled(a_bEnable);
            this.m_labelCSTL.setEnabled(a_bEnable);
            this.m_labelO.setEnabled(a_bEnable);
            this.m_labelOU.setEnabled(a_bEnable);
            this.m_labelDateData.setEnabled(a_bEnable);
            this.m_labelCNData.setEnabled(a_bEnable);
            this.m_labelEData.setEnabled(a_bEnable);
            this.m_labelCSTLData.setEnabled(a_bEnable);
            this.m_labelOData.setEnabled(a_bEnable);
            this.m_labelOUData.setEnabled(a_bEnable);
            super.setEnabled(a_bEnable);
        }

        public void update(JAPCertificate a_cert) {
            String strCSTL = null;
            this.m_selectedCert = a_cert;
            this.m_labelCNData.setText("");
            this.m_labelEData.setText("");
            this.m_labelCSTLData.setText("");
            this.m_labelOData.setText("");
            this.m_labelOUData.setText("");
            this.m_labelDateData.setText("");
            if (a_cert == null) {
                return;
            }
            StringBuffer strBuff = new StringBuffer();
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            strBuff.append(sdf.format(a_cert.getValidity().getValidFrom()));
            strBuff.append(" - ");
            strBuff.append(sdf.format(a_cert.getValidity().getValidTo()));
            this.m_labelDateData.setText(strBuff.toString());
            X509DistinguishedName name = a_cert.getSubject();
            if (name.getCommonName() != null && name.getCommonName().trim().length() > 0) {
                this.m_labelCNData.setText(name.getCommonName().trim());
            }
            if (name.getEmailAddress() != null && name.getEmailAddress().trim().length() > 0) {
                this.m_labelEData.setText(name.getEmailAddress().trim());
            } else if (name.getE_EmailAddress() != null && name.getE_EmailAddress().trim().length() > 0) {
                this.m_labelEData.setText(name.getE_EmailAddress());
            }
            if (name.getLocalityName() != null && name.getLocalityName().trim().length() > 0) {
                strCSTL = name.getLocalityName().trim();
            }
            if (name.getStateOrProvince() != null && name.getStateOrProvince().trim().length() > 0) {
                strCSTL = strCSTL != null ? strCSTL + ", " : "";
                strCSTL = strCSTL + name.getStateOrProvince().trim();
            }
            if (name.getCountryCode() != null) {
                String country;
                try {
                    country = new CountryMapper(name.getCountryCode(), JAPMessages.getLocale()).toString();
                }
                catch (IllegalArgumentException a_e) {
                    country = name.getCountryCode();
                }
                if (country.trim().length() > 0) {
                    strCSTL = strCSTL != null ? strCSTL + ", " : "";
                    strCSTL = strCSTL + country.trim();
                }
            }
            this.m_labelCSTLData.setText(strCSTL);
            if (name.getOrganisation() != null && name.getOrganisation().trim().length() > 0) {
                this.m_labelOData.setText(name.getOrganisation().trim());
            }
            if (name.getOrganisationalUnit() != null && name.getOrganisationalUnit().trim().length() > 0) {
                this.m_labelOUData.setText(name.getOrganisationalUnit().trim());
            }
        }
    }
}

