/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import anon.util.IXMLEncodable;
import anon.util.JAPMessages;
import anon.util.XMLUtil;
import mixconfig.panels.MixOnCDPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ConnectionData
implements IXMLEncodable,
Cloneable {
    public static final int TRANSPORT = 1;
    public static final int TCP = 0;
    public static final int UNIX = 1;
    public static final int RAW = 0;
    public static final int SSL = 2;
    public static final int RAW_TCP = 0;
    public static final int RAW_UNIX = 1;
    public static final int SSL_TCP = 2;
    public static final int SSL_UNIX = 3;
    public static final int PROXY_MASK = 7;
    public static final int NO_PROXY = 0;
    public static final int HTTP_PROXY = 1;
    public static final int SOCKS_PROXY = 2;
    public static final int VPN_PROXY = 4;
    private String m_strXMLNodeName;
    private int m_iTransport;
    private String m_strHostname;
    private int m_iPort;
    private String m_strVisibleAddress;
    private int m_iFlags;
    private boolean m_bIsVirtual = false;
    private boolean m_bIsHidden = false;

    public ConnectionData(String a_strXMLNodeName, int a_iTransport, String a_strHostname) {
        this(a_strXMLNodeName, a_iTransport, a_strHostname, 0);
    }

    public ConnectionData(String a_strXMLNodeName, int a_iTransport, String a_strHostname, int a_iFlags) {
        this(a_strXMLNodeName, a_iTransport, a_strHostname, 0, a_iFlags, false, false);
    }

    public ConnectionData(String a_strXMLNodeName, int a_iTransport, String a_strHostname, int a_iPort, int a_iFlags, boolean virtual, boolean hidden) {
        this(a_strXMLNodeName, a_iTransport, a_strHostname, a_iPort, null, a_iFlags, virtual, hidden);
    }

    public ConnectionData(String a_strXMLNodeName, int a_iTransport, String a_strHostname, int a_iPort, String a_strVisibleAddress, int a_iFlags, boolean virtual, boolean hidden) {
        this.setType(a_strXMLNodeName);
        this.setTransport(a_iTransport);
        this.setHostname(a_strHostname);
        this.setPort(a_iPort);
        this.setVisibleAddress(a_strVisibleAddress);
        this.setFlags(a_iFlags);
        this.setIsVirtual(virtual);
        this.setIsHidden(hidden);
    }

    public Object clone() {
        return new ConnectionData(this.m_strXMLNodeName, this.m_iTransport, this.m_strHostname, this.m_iPort, this.m_iFlags, this.m_bIsVirtual, this.m_bIsHidden);
    }

    void setFlags(int f) {
        this.m_iFlags = f;
    }

    public int getFlags() {
        return this.m_iFlags;
    }

    void setType(String t) {
        this.m_strXMLNodeName = t;
    }

    String getType() {
        return this.m_strXMLNodeName;
    }

    void setTransport(int t) {
        this.m_iTransport = t;
    }

    public int getTransport() {
        return this.m_iTransport;
    }

    public void setHostname(String n) {
        this.m_strHostname = n;
    }

    public String getHostname() {
        return this.m_strHostname;
    }

    public void setVisibleAddress(String n) {
        this.m_strVisibleAddress = n;
    }

    public String getVisibleAddress() {
        return this.m_strVisibleAddress;
    }

    void setPort(int p) {
        this.m_iPort = p;
    }

    public int getPort() {
        return this.m_iPort;
    }

    void setIsHidden(boolean b) {
        this.m_bIsHidden = b;
    }

    public boolean isHidden() {
        return this.m_bIsHidden;
    }

    void setIsVirtual(boolean b) {
        this.m_bIsVirtual = b;
    }

    public boolean isVirtual() {
        return this.m_bIsVirtual;
    }

    public String getVisibilityString() {
        if (this.m_bIsVirtual) {
            return new String("Virtual");
        }
        if (this.m_bIsHidden) {
            return new String("Hidden");
        }
        return new String("");
    }

    @Override
    public Element toXmlElement(Document docOwner) {
        Element data;
        boolean isProxy;
        Element elemRoot = docOwner.createElement(this.m_strXMLNodeName);
        boolean bl = isProxy = (this.m_iFlags & 7) != 0;
        if (this.isHidden()) {
            elemRoot.setAttribute("hidden", "True");
        }
        if (this.isVirtual()) {
            elemRoot.setAttribute("virtual", "True");
        }
        if (isProxy) {
            data = docOwner.createElement("ProxyType");
            int proxytype = this.m_iFlags & 7;
            String strProxyType = "";
            if (proxytype == 1) {
                strProxyType = "HTTP";
            }
            if (proxytype == 2) {
                strProxyType = "SOCKS";
            }
            if (proxytype == 4) {
                strProxyType = "VPN";
            }
            data.appendChild(docOwner.createTextNode(strProxyType));
            elemRoot.appendChild(data);
        }
        data = docOwner.createElement("NetworkProtocol");
        data.appendChild(docOwner.createTextNode(((this.m_iTransport & 2) == 0 ? "RAW/" : "SSL/") + ((this.m_iTransport & 1) == 0 ? "TCP" : "UNIX")));
        elemRoot.appendChild(data);
        if ((this.m_iTransport & 1) == 0) {
            data = docOwner.createElement("Host");
            if (!this.m_strHostname.equalsIgnoreCase(JAPMessages.getString(MixOnCDPanel.MSG_CONFIGURED_BY_MIXONCD))) {
                data.appendChild(docOwner.createTextNode(this.m_strHostname));
            }
            elemRoot.appendChild(data);
            data = docOwner.createElement("Port");
            data.appendChild(docOwner.createTextNode(String.valueOf(this.m_iPort)));
            elemRoot.appendChild(data);
        } else {
            data = docOwner.createElement("File");
            if (!this.m_strHostname.equalsIgnoreCase(JAPMessages.getString(MixOnCDPanel.MSG_CONFIGURED_BY_MIXONCD))) {
                data.appendChild(docOwner.createTextNode(this.m_strHostname));
            }
            elemRoot.appendChild(data);
        }
        if (isProxy) {
            Element visibleAddresses = docOwner.createElement("VisibleAddresses");
            data = docOwner.createElement("VisibleAddress");
            if (this.m_strVisibleAddress != null) {
                data.appendChild(docOwner.createTextNode(this.m_strVisibleAddress));
            }
            visibleAddresses.appendChild(data);
            elemRoot.appendChild(visibleAddresses);
        }
        return elemRoot;
    }

    static ConnectionData createFromElement(String tag, Element elemRoot) {
        if (!elemRoot.getTagName().equals(tag)) {
            return null;
        }
        int port = 0;
        boolean hidden = false;
        boolean virtual = false;
        String tmp = elemRoot.getAttribute("hidden");
        if (tmp != null && tmp.equals("True")) {
            hidden = true;
        }
        if ((tmp = elemRoot.getAttribute("virtual")) != null && tmp.equals("True")) {
            virtual = true;
        }
        int ptype = 0;
        String data = ConnectionData.getChildElementValue(elemRoot, "ProxyType");
        if (data == null) {
            ptype = 0;
        } else if (data.equalsIgnoreCase("HTTP")) {
            ptype = 1;
        } else if (data.equalsIgnoreCase("SOCKS")) {
            ptype = 2;
        } else if (data.equalsIgnoreCase("VPN")) {
            ptype = 4;
        }
        data = ConnectionData.getChildElementValue(elemRoot, "NetworkProtocol");
        int trans = data != null ? (data.equalsIgnoreCase("RAW/UNIX") ? 1 : (data.equalsIgnoreCase("RAW/TCP") ? 0 : (data.equalsIgnoreCase("SSL/UNIX") ? 3 : (data.equalsIgnoreCase("SSL/TCP") ? 2 : 0)))) : (ConnectionData.getChildElementValue(elemRoot, "File") != null ? 1 : 0);
        if (!(trans & true)) {
            String host = ConnectionData.getChildElementValue(elemRoot, "Host");
            if (host == null) {
                host = "";
            }
            port = (data = ConnectionData.getChildElementValue(elemRoot, "Port")) == null ? 0 : Integer.parseInt(data);
            if (ptype == 0) {
                return new ConnectionData(tag, trans, host, port, ptype, virtual, hidden);
            }
            Node visibleAddresses = XMLUtil.getFirstChildByName(elemRoot, "VisibleAddresses");
            String address = ConnectionData.getChildElementValue((Element)visibleAddresses, "VisibleAddress");
            return new ConnectionData(tag, trans, host, port, address, ptype, virtual, hidden);
        }
        String host = ConnectionData.getChildElementValue(elemRoot, "File");
        if (host == null) {
            host = "";
        }
        return new ConnectionData(tag, trans, host, ptype);
    }

    private static String getChildElementValue(Element elemParent, String childName) {
        Node nodeChild = XMLUtil.getFirstChildByName(elemParent, childName);
        return XMLUtil.parseValue(nodeChild, null);
    }
}

