/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.proxy.AnonProxyRequest;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackBuffer;
import anon.proxy.ProxyCallbackNotProcessableException;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import logging.LogHolder;
import logging.LogType;

public class DecompressionProxyCallback
implements ProxyCallback {
    Hashtable decompressionKits = new Hashtable();
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private final int MAX_DECOMPRESSION_OUTPUT = 10000;

    private int readGZIPHeader(byte[] byArray, int n, int n2) throws DataFormatException {
        int n3;
        int n4 = n;
        if ((n3 = this.toUnsignedShort(byArray[n4++], byArray[n4++])) != 35615) {
            throw new DataFormatException("Not in GZIP format");
        }
        if (this.toUnsignedByte(byArray[n4++]) != 8) {
            throw new DataFormatException("Unsupported compression method");
        }
        int n5 = this.toUnsignedByte(byArray[n4++]);
        n4 += 6;
        if ((n5 & 4) == 4) {
            n4 = n4 + this.toUnsignedShort(byArray[n4++], byArray[n4++]);
        }
        if ((n5 & 8) == 8) {
            while (this.toUnsignedShort(byArray[n4++], byArray[n4++]) != 0) {
            }
        }
        if ((n5 & 0x10) == 16) {
            while (this.toUnsignedShort(byArray[n4++], byArray[n4++]) != 0) {
            }
        }
        if ((n5 & 2) == 2) {
            n4 += 2;
        }
        if (n4 >= n + n2) {
            throw new ArrayIndexOutOfBoundsException("index " + n4 + " exceeds " + (n + n2));
        }
        return n4 - n;
    }

    private int toUnsignedShort(byte by, byte by2) {
        return this.toUnsignedByte(by2) << 8 | by;
    }

    private int toUnsignedByte(byte by) {
        return (by < 0 ? 128 : 0) + (0x7F & by);
    }

    public void closeRequest(AnonProxyRequest anonProxyRequest) {
        DecompressionKit decompressionKit = (DecompressionKit)this.decompressionKits.remove(anonProxyRequest);
        if (decompressionKit != null) {
            if (decompressionKit.getGzipInflater() != null) {
                decompressionKit.getGzipInflater().end();
            }
            if (decompressionKit.getZLibInflater() != null) {
                decompressionKit.getZLibInflater().end();
            }
        }
    }

    public synchronized int handleDownstreamChunk(AnonProxyRequest anonProxyRequest, ProxyCallbackBuffer proxyCallbackBuffer) throws ProxyCallbackNotProcessableException {
        String[] stringArray;
        if (proxyCallbackBuffer.getModificationStartOffset() < proxyCallbackBuffer.getPayloadLength() && (stringArray = anonProxyRequest.getContentEncodings()) != null) {
            Object object;
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = null;
            for (int i = 0; i < stringArray.length; ++i) {
                stringTokenizer = new StringTokenizer(stringArray[i], "");
                object = null;
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).trim().equals("gzip") || ((String)object).trim().equals("deflate")) {
                        vector.addElement((String)object);
                        continue;
                    }
                    LogHolder.log(4, LogType.NET, "The Content-Encoding " + (String)object + " is not supported.");
                }
            }
            if (vector.size() > 0) {
                String string = null;
                object = null;
                DecompressionKit decompressionKit = null;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                try {
                    for (int i = 0; i < vector.size(); ++i) {
                        string = (String)vector.elementAt(i);
                        int n5 = proxyCallbackBuffer.getModificationEndOffset() - proxyCallbackBuffer.getModificationStartOffset() + 1;
                        int n6 = 0;
                        boolean bl = string.equals("gzip");
                        decompressionKit = (DecompressionKit)this.decompressionKits.get(anonProxyRequest);
                        if (decompressionKit == null) {
                            decompressionKit = new DecompressionKit();
                            decompressionKit.setNewInflater(bl);
                            decompressionKit.setResult(new byte[10000]);
                            n6 = bl ? this.readGZIPHeader(proxyCallbackBuffer.getChunk(), proxyCallbackBuffer.getModificationStartOffset(), n5) : 0;
                            this.decompressionKits.put(anonProxyRequest, decompressionKit);
                        }
                        Object object2 = object = bl ? decompressionKit.getGzipInflater() : decompressionKit.getZLibInflater();
                        if (!((Inflater)object).needsInput()) continue;
                        n2 = proxyCallbackBuffer.getLeadingDataLength();
                        n3 = proxyCallbackBuffer.getTrailingDataLength();
                        n4 = decompressionKit.getResult().length - n3 - n2;
                        ((Inflater)object).setInput(proxyCallbackBuffer.getChunk(), proxyCallbackBuffer.getModificationStartOffset() + n6, n5 - n6);
                        ByteArrayOutputStream byteArrayOutputStream = null;
                        n = ((Inflater)object).inflate(decompressionKit.getResult(), n2, n4);
                        while (n == n4 && !((Inflater)object).needsInput()) {
                            if (byteArrayOutputStream == null) {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                proxyCallbackBuffer.copyLeadingData(byteArrayOutputStream);
                                byteArrayOutputStream.write(decompressionKit.getResult(), n2, n4);
                            }
                            n4 = decompressionKit.getResult().length;
                            n = ((Inflater)object).inflate(decompressionKit.getResult());
                            byteArrayOutputStream.write(decompressionKit.getResult(), 0, n);
                        }
                        if (byteArrayOutputStream == null) {
                            proxyCallbackBuffer.copyLeadingData(decompressionKit.getResult());
                            proxyCallbackBuffer.copyTrailingData(decompressionKit.getResult(), n2 + n);
                            proxyCallbackBuffer.setChunk(decompressionKit.getResult());
                            proxyCallbackBuffer.setModificationStartOffset(n2 + n);
                            proxyCallbackBuffer.setModificationEndOffset(proxyCallbackBuffer.getModificationStartOffset());
                            proxyCallbackBuffer.setPayloadLength(proxyCallbackBuffer.getModificationStartOffset() + n3);
                        } else {
                            proxyCallbackBuffer.copyTrailingData(byteArrayOutputStream);
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            proxyCallbackBuffer.setChunk(byArray);
                            proxyCallbackBuffer.setModificationStartOffset(byArray.length - n3);
                            proxyCallbackBuffer.setModificationEndOffset(proxyCallbackBuffer.getModificationStartOffset());
                        }
                        if (!((Inflater)object).finished()) continue;
                        LogHolder.log(6, LogType.NET, "finish connection after decompressing.");
                        ((Inflater)object).reset();
                        proxyCallbackBuffer.setStatus(0);
                        return 0;
                    }
                }
                catch (DataFormatException dataFormatException) {
                    if (object != null) {
                        ((Inflater)object).reset();
                    }
                    LogHolder.log(4, LogType.NET, "compressed data has invalid format.", dataFormatException);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (object != null) {
                        ((Inflater)object).reset();
                    }
                    LogHolder.log(3, LogType.NET, "indexing error occured while decompressing data. Maybe the result buffer is too small?", arrayIndexOutOfBoundsException);
                }
            }
        }
        return 2;
    }

    public int handleUpstreamChunk(AnonProxyRequest anonProxyRequest, ProxyCallbackBuffer proxyCallbackBuffer) throws ProxyCallbackNotProcessableException {
        return 2;
    }

    private static class DecompressionKit {
        private Inflater gzipInflater = null;
        private Inflater zLibInflater = null;
        private byte[] result = null;

        private DecompressionKit() {
        }

        public byte[] getResult() {
            return this.result;
        }

        public void setResult(byte[] byArray) {
            this.result = byArray;
        }

        public Inflater getGzipInflater() {
            return this.gzipInflater;
        }

        public void setGzipInflater(Inflater inflater) {
            this.gzipInflater = inflater;
        }

        public Inflater getZLibInflater() {
            return this.zLibInflater;
        }

        public void setZLibInflater(Inflater inflater) {
            this.zLibInflater = inflater;
        }

        private void setNewInflater(boolean bl) {
            if (bl) {
                this.setGzipInflater(new Inflater(true));
            } else {
                this.setZLibInflater(new Inflater());
            }
        }
    }
}

