/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import junitx.framework.TestAccessException;

public class TestedClass {
    private final Class _class;
    private final Map _methods = new TreeMap();
    private final Map _constructors = new TreeMap();

    public TestedClass(Class clazz) {
        this._class = clazz;
        this.createMethodMap();
        this.createConstructorMap();
    }

    public Class getTestedClass() {
        return this._class;
    }

    public String getPkgName() {
        String string = this._class.toString().substring(6);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    private String createMethodKey(String string, Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        boolean bl = false;
        stringBuffer.append(string);
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append("_");
            string2 = classArray[n].getName();
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    private Class[] objToClassArray(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        return classArray;
    }

    public Method getMethod(String string) {
        return (Method)this._methods.get(string);
    }

    public Method getMethod(String string, Object[] objectArray) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredMethod(string, this.objToClassArray(objectArray));
        }
        catch (Exception exception) {
            throw new TestAccessException("cannot access method " + string, exception);
        }
    }

    public Constructor getConstructor(Object[] objectArray) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredConstructor(this.objToClassArray(objectArray));
        }
        catch (Exception exception) {
            throw new TestAccessException("cannot find constructor", exception);
        }
    }

    public Constructor getConstructor(String string) {
        return (Constructor)this._constructors.get(string);
    }

    private void createMethodMap() {
        Method[] methodArray = this.getTestedClass().getDeclaredMethods();
        Method[] methodArray2 = this.getTestedClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            this._methods.put(this.createMethodKey(methodArray[n].getName(), methodArray[n].getParameterTypes()), methodArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < methodArray2.length) {
            this._methods.put(this.createMethodKey(methodArray2[n2].getName(), methodArray2[n2].getParameterTypes()), methodArray2[n2]);
            ++n2;
        }
        Class clazz = this.getTestedClass().getSuperclass();
        while (clazz != null) {
            Method[] methodArray3 = clazz.getDeclaredMethods();
            int n3 = 0;
            while (n3 < methodArray3.length) {
                if ((methodArray3[n3].getModifiers() & 4) != 0) {
                    this._methods.put(this.createMethodKey(methodArray3[n3].getName(), methodArray3[n3].getParameterTypes()), methodArray3[n3]);
                }
                ++n3;
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void createConstructorMap() {
        Constructor<?>[] constructorArray = this.getTestedClass().getDeclaredConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            this._constructors.put(this.createMethodKey("", constructorArray[n].getParameterTypes()), constructorArray[n]);
            ++n;
        }
    }

    public Field getField(String string) throws TestAccessException {
        try {
            return this.getTestedClass().getDeclaredField(string);
        }
        catch (Exception exception) {
            throw new TestAccessException("cannot access field " + string, exception);
        }
    }

    public void dumpKeys() {
        Iterator iterator = this._constructors.keySet().iterator();
        Iterator iterator2 = this._methods.keySet().iterator();
        System.out.println(this.getTestedClass().getName() + " constructors:");
        while (iterator.hasNext()) {
            System.out.println("    " + (String)iterator.next());
        }
        System.out.println("\n" + this.getTestedClass().getName() + " methods:");
        while (iterator2.hasNext()) {
            System.out.println("    " + (String)iterator2.next());
        }
    }
}

