/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class LabelView
extends View
implements TabableView {
    Font font;
    FontMetrics metrics;
    Color fg;
    Color bg;
    Segment text = new Segment();
    boolean underline;
    boolean strike;
    boolean superscript;
    boolean subscript;
    boolean rightToLeft;
    TabExpander expander;
    int x;

    public LabelView(Element element) {
        super(element);
        int n = element.getStartOffset();
        int n2 = element.getEndOffset();
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            this.rightToLeft = ((AbstractDocument)document).isLeftToRight(n, n2) ^ true;
        }
    }

    public View breakView(int n, int n2, float f, float f2) {
        if (n == 0) {
            this.sync();
            this.loadText(n2, this.getEndOffset());
            int n3 = Utilities.getBreakLocation(this.text, this.metrics, (int)f, (int)(f + f2), this.expander, n2);
            int n4 = n2 + n3;
            LabelFragment labelFragment = new LabelFragment(this.getElement(), n2, n4);
            labelFragment.x = (int)f;
            return labelFragment;
        }
        return this;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.font = null;
    }

    public View createFragment(int n, int n2) {
        Element element = this.getElement();
        return new LabelFragment(element, n, n2);
    }

    public float getAlignment(int n) {
        if (n == 1) {
            float f = this.metrics.getHeight();
            float f2 = this.metrics.getDescent();
            float f3 = (f - f2) / f;
            return f3;
        }
        return super.getAlignment(n);
    }

    public int getBreakWeight(int n, float f, float f2) {
        return this.getBreakWeight(n, f, f2, this.getStartOffset(), this.getEndOffset());
    }

    int getBreakWeight(int n, float f, float f2, int n2, int n3) {
        if (n == 0) {
            this.sync();
            this.loadText(n2, n3);
            int n4 = Utilities.getTabbedTextOffset(this.text, this.metrics, (int)f, (int)(f + f2), this.expander, n2);
            if (n4 == 0) {
                return 0;
            }
            int n5 = this.text.offset + Math.min(n4, this.text.count - 1);
            while (n5 >= this.text.offset) {
                char c = this.text.array[n5];
                if (Character.isWhitespace(c)) {
                    return 2000;
                }
                --n5;
            }
            return 1000;
        }
        return super.getBreakWeight(n, f, f2);
    }

    protected Font getFont() {
        this.sync();
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        this.sync();
        return this.metrics;
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        int n3 = this.getNextVisualPositionFrom(n, bias, shape, n2, biasArray, this.rightToLeft, this.getStartOffset(), this.getEndOffset());
        return n3;
    }

    int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, boolean bl, int n3, int n4) throws BadLocationException {
        switch (n2) {
            case 3: {
                if (n3 == this.getDocument().getLength()) {
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    return -1;
                }
                if (bl) {
                    if (n == -1) {
                        this.loadText(n4 - 1, n4);
                        if (this.text.array[this.text.offset] == '\n') {
                            biasArray[0] = Position.Bias.Forward;
                            return n4 - 1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                        return n4;
                    }
                    if (n == n3) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n - 1;
                }
                if (n == -1) {
                    biasArray[0] = Position.Bias.Forward;
                    return n3;
                }
                if (n == n4) {
                    return -1;
                }
                if (++n == n4) {
                    this.loadText(n4 - 1, n4);
                    if (this.text.array[this.text.offset] == '\n') {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    biasArray[0] = Position.Bias.Forward;
                }
                return n;
            }
            case 7: {
                if (n3 == this.getDocument().getLength()) {
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    return -1;
                }
                if (bl) {
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    if (n == n4) {
                        return -1;
                    }
                    if (++n == n4) {
                        this.loadText(n4 - 1, n4);
                        if (this.text.array[this.text.offset] == '\n') {
                            return -1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                    } else {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    return n;
                }
                if (n == -1) {
                    this.loadText(n4 - 1, n4);
                    if (this.text.array[this.text.offset] == '\n') {
                        biasArray[0] = Position.Bias.Forward;
                        return n4 - 1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                    return n4;
                }
                if (n == n3) {
                    return -1;
                }
                biasArray[0] = Position.Bias.Forward;
                return n - 1;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
            case 1: 
            case 5: 
        }
        return n;
    }

    public float getPartialSpan(int n, int n2) {
        this.sync();
        int n3 = 0;
        try {
            Segment segment = new Segment();
            this.getDocument().getText(n, n2 - n, segment);
            n3 = Utilities.getTabbedTextWidth(segment, this.metrics, this.x, this.expander, n);
        }
        catch (BadLocationException badLocationException) {}
        return n3;
    }

    public float getPreferredSpan(int n) {
        return this.getPreferredSpan(n, this.getStartOffset(), this.getEndOffset(), this.x);
    }

    final float getPreferredSpan(int n, int n2, int n3, int n4) {
        this.sync();
        switch (n) {
            case 0: {
                this.loadText(n2, n3);
                int n5 = Utilities.getTabbedTextWidth(this.text, this.metrics, n4, this.expander, n2);
                return Math.max(n5, 1);
            }
            case 1: {
                return this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getTabbedSpan(float f, TabExpander tabExpander) {
        this.expander = tabExpander;
        this.x = (int)f;
        return this.getPreferredSpan(0, this.getStartOffset(), this.getEndOffset(), this.x);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.insertUpdate(documentEvent, shape, viewFactory);
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            this.rightToLeft = ((AbstractDocument)document).isLeftToRight(n, n2) ^ true;
        }
    }

    final void loadText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.text);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("LabelView: Stale view: " + badLocationException);
        }
    }

    Shape modelToView(int n, Shape shape, int n2, int n3, Position.Bias bias, boolean bl) throws BadLocationException {
        Rectangle rectangle = shape.getBounds();
        if (n == n3) {
            this.loadText(n2, n2 + 1);
            this.sync();
            if (!bl) {
                return new Rectangle(rectangle.x + rectangle.width, rectangle.y, 0, this.metrics.getHeight());
            }
            return new Rectangle(rectangle.x, rectangle.y, 0, this.metrics.getHeight());
        }
        if (n >= n2 && n <= n3) {
            this.loadText(n2, n);
            this.sync();
            int n4 = Utilities.getTabbedTextWidth(this.text, this.metrics, rectangle.x, this.expander, n2);
            if (bl) {
                return new Rectangle(rectangle.x + rectangle.width - n4, rectangle.y, 0, this.metrics.getHeight());
            }
            return new Rectangle(rectangle.x + n4, rectangle.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", n3);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        return this.modelToView(n, shape, this.getStartOffset(), this.getEndOffset(), bias, this.rightToLeft);
    }

    public void paint(Graphics graphics, Shape shape) {
        Highlighter highlighter;
        Serializable serializable;
        Container container = this.getContainer();
        if (this.bg != null) {
            serializable = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.setColor(this.bg);
            graphics.fillRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
        }
        if (container instanceof JTextComponent && (highlighter = ((JTextComponent)(serializable = (JTextComponent)container)).getHighlighter()) instanceof LayeredHighlighter) {
            ((LayeredHighlighter)highlighter).paintLayeredHighlights(graphics, this.getStartOffset(), this.getEndOffset(), shape, (JTextComponent)serializable, this);
        }
        this.paintText(container, graphics, shape, this.getStartOffset(), this.getEndOffset(), false, this.rightToLeft);
    }

    void paintText(Component component, Graphics graphics, Shape shape, int n, int n2, boolean bl, boolean bl2) {
        JTextComponent jTextComponent;
        Color color;
        Rectangle rectangle = shape.getBounds();
        this.sync();
        int n3 = rectangle.y + rectangle.height - this.metrics.getDescent();
        graphics.setFont(this.font);
        boolean bl3 = false;
        if (component instanceof JTextComponent && (color = (jTextComponent = (JTextComponent)component).getSelectedTextColor()) != null && !color.equals(this.fg)) {
            int n4;
            int n5;
            int n6;
            Position.Bias[] biasArray = new Position.Bias[1];
            Position.Bias[] biasArray2 = new Position.Bias[1];
            int n7 = jTextComponent.getSelectionStart(biasArray);
            if (n7 != (n6 = jTextComponent.getSelectionEnd(biasArray2)) && (n5 = n7 <= n ? n : Math.min(n7, n2)) != (n4 = n6 >= n2 ? n2 : Math.max(n6, n))) {
                int n8 = rectangle.x;
                bl3 = true;
                if (n5 > n) {
                    n8 = this.paintTextUsingColor(n8, n3, graphics, n, n5, this.fg, bl);
                }
                n8 = this.paintTextUsingColor(n8, n3, graphics, n5, n4, color, bl);
                if (n4 < n2) {
                    this.paintTextUsingColor(n8, n3, graphics, n4, n2, this.fg, bl);
                }
            }
        }
        if (!bl3) {
            this.paintTextUsingColor(rectangle.x, n3, graphics, n, n2, this.fg, bl);
        }
    }

    final int paintTextUsingColor(int n, int n2, Graphics graphics, int n3, int n4, Color color, boolean bl) {
        int n5 = n;
        graphics.setColor(color);
        this.loadText(n3, n4);
        if (this.superscript) {
            n2 -= this.metrics.getAscent() / 2;
        } else if (this.subscript) {
            n2 += this.metrics.getDescent();
        }
        n = Utilities.drawTabbedText(this.text, n, n2, graphics, this.expander, n3);
        if (this.underline || this.strike) {
            int n6 = n - n5;
            if (bl) {
                while (this.text.count > 0 && Character.isWhitespace(this.text.array[this.text.count - 1])) {
                    n6 -= this.metrics.charWidth(this.text.array[this.text.count - 1]);
                    --this.text.count;
                }
            }
            if (this.underline) {
                ++n2;
            } else if (this.strike) {
                n2 -= this.metrics.getAscent() / 2;
            }
            graphics.drawLine(n5, n2, n, n2);
        }
        return n;
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            Document document = this.getDocument();
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                this.font = styledDocument.getFont(attributeSet);
                this.fg = styledDocument.getForeground(attributeSet);
                this.bg = attributeSet.isDefined(StyleConstants.Background) ? styledDocument.getBackground(attributeSet) : null;
                this.setUnderline(StyleConstants.isUnderline(attributeSet));
                this.setStrikeThrough(StyleConstants.isStrikeThrough(attributeSet));
                this.setSuperscript(StyleConstants.isSuperscript(attributeSet));
                this.setSubscript(StyleConstants.isSubscript(attributeSet));
                this.metrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            } else {
                throw new StateInvariantError("LabelView needs StyledDocument");
            }
        }
    }

    protected void setStrikeThrough(boolean bl) {
        this.strike = bl;
    }

    protected void setSubscript(boolean bl) {
        this.subscript = bl;
    }

    protected void setSuperscript(boolean bl) {
        this.superscript = bl;
    }

    protected void setUnderline(boolean bl) {
        this.underline = bl;
    }

    final void sync() {
        if (this.font == null) {
            this.setPropertiesFromAttributes();
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        return this.viewToModel(f, f2, shape, biasArray, this.getStartOffset(), this.getEndOffset(), this.rightToLeft);
    }

    int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray, int n, int n2, boolean bl) {
        Rectangle rectangle = shape.getBounds();
        this.sync();
        this.loadText(n, n2);
        int n3 = Utilities.getTabbedTextOffset(this.text, this.metrics, rectangle.x, (int)f, this.expander, n);
        int n4 = bl ? n2 - n3 : n + n3;
        biasArray[0] = n4 == n2 ? Position.Bias.Backward : Position.Bias.Forward;
        return n4;
    }

    class LabelFragment
    extends View
    implements TabableView {
        short offset;
        short length;
        int x;
        boolean rightToLeft;

        public LabelFragment(Element element, int n, int n2) {
            super(element);
            this.offset = (short)(n - element.getStartOffset());
            this.length = (short)(n2 - n);
            Document document = this.getDocument();
            if (document instanceof AbstractDocument) {
                this.rightToLeft = ((AbstractDocument)document).isLeftToRight(n, n2) ^ true;
            }
        }

        public View breakView(int n, int n2, float f, float f2) {
            return LabelView.this.breakView(n, n2, f, f2);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            LabelView.this.changedUpdate(documentEvent, shape, viewFactory);
        }

        public float getAlignment(int n) {
            return LabelView.this.getAlignment(n);
        }

        public AttributeSet getAttributes() {
            return LabelView.this.getAttributes();
        }

        public int getBreakWeight(int n, float f, float f2) {
            return LabelView.this.getBreakWeight(n, f, f2, this.getStartOffset(), this.getEndOffset());
        }

        public int getEndOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset + this.length;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = LabelView.this.getNextVisualPositionFrom(n, bias, shape, n2, biasArray, this.rightToLeft, this.getStartOffset(), this.getEndOffset());
            return n3;
        }

        public float getPartialSpan(int n, int n2) {
            return LabelView.this.getPartialSpan(n, n2);
        }

        public float getPreferredSpan(int n) {
            return LabelView.this.getPreferredSpan(n, this.getStartOffset(), this.getEndOffset(), this.x);
        }

        public int getStartOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset;
        }

        public float getTabbedSpan(float f, TabExpander tabExpander) {
            LabelView.this.expander = tabExpander;
            this.x = (int)f;
            return LabelView.this.getPreferredSpan(0, this.getStartOffset(), this.getEndOffset(), this.x);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return LabelView.this.modelToView(n, shape, this.getStartOffset(), this.getEndOffset(), bias, this.rightToLeft);
        }

        public void paint(Graphics graphics, Shape shape) {
            Highlighter highlighter;
            Serializable serializable;
            Container container = this.getContainer();
            if (LabelView.this.bg != null) {
                serializable = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                graphics.setColor(LabelView.this.bg);
                graphics.fillRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            }
            if (container instanceof JTextComponent && (highlighter = ((JTextComponent)(serializable = (JTextComponent)container)).getHighlighter()) instanceof LayeredHighlighter) {
                ((LayeredHighlighter)highlighter).paintLayeredHighlights(graphics, this.getStartOffset(), this.getEndOffset(), shape, (JTextComponent)serializable, this);
            }
            LabelView.this.paintText(container, graphics, shape, this.getStartOffset(), this.getEndOffset(), true, this.rightToLeft);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            return LabelView.this.viewToModel(f, f2, shape, biasArray, this.getStartOffset(), this.getEndOffset(), this.rightToLeft);
        }
    }
}

