/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class BasicIconFactory
implements Serializable {
    private static Icon frame_icon;
    private static Icon checkBoxIcon;
    private static Icon radioButtonIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon createEmptyFrameIcon() {
        if (frame_icon == null) {
            frame_icon = new EmptyFrameIcon();
        }
        return frame_icon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    private static class EmptyFrameIcon
    implements Icon,
    Serializable {
        int height = 16;
        int width = 14;

        EmptyFrameIcon() {
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class CheckBoxIcon
    implements Icon,
    Serializable {
        static final int csize = 13;

        CheckBoxIcon() {
        }

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonIcon() {
        }

        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        CheckBoxMenuItemIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            boolean bl = buttonModel.isSelected();
            if (bl) {
                graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 3);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 4);
                graphics.drawLine(n + 5, n2 + 3, n + 5, n2 + 5);
                graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 6);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 7);
                graphics.drawLine(n + 2, n2 + 4, n + 2, n2 + 6);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 5);
            }
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        RadioButtonMenuItemIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isSelected()) {
                graphics.fillArc(n + 1, n2 + 1, this.getIconWidth() - 2, this.getIconHeight() - 2, 0, 360);
            }
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        MenuItemCheckIcon() {
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        MenuItemArrowIcon() {
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 4;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        MenuArrowIcon() {
        }

        public int getIconHeight() {
            return 8;
        }

        public int getIconWidth() {
            return 4;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Polygon polygon = new Polygon();
            polygon.addPoint(n, n2);
            polygon.addPoint(n + this.getIconWidth(), n2 + this.getIconHeight() / 2);
            polygon.addPoint(n, n2 + this.getIconHeight());
            graphics.fillPolygon(polygon);
        }
    }
}

